/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceStatus implements ToCopyableBuilder<InstanceStatus.Builder, InstanceStatus> {
    private final String availabilityZone;

    private final List<InstanceStatusEvent> events;

    private final String instanceId;

    private final InstanceState instanceState;

    private final InstanceStatusSummary instanceStatus;

    private final InstanceStatusSummary systemStatus;

    private InstanceStatus(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.events = builder.events;
        this.instanceId = builder.instanceId;
        this.instanceState = builder.instanceState;
        this.instanceStatus = builder.instanceStatus;
        this.systemStatus = builder.systemStatus;
    }

    /**
     * <p>
     * The Availability Zone of the instance.
     * </p>
     * 
     * @return The Availability Zone of the instance.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Any scheduled events associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any scheduled events associated with the instance.
     */
    public List<InstanceStatusEvent> events() {
        return events;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The intended state of the instance. <a>DescribeInstanceStatus</a> requires that an instance be in the
     * <code>running</code> state.
     * </p>
     * 
     * @return The intended state of the instance. <a>DescribeInstanceStatus</a> requires that an instance be in the
     *         <code>running</code> state.
     */
    public InstanceState instanceState() {
        return instanceState;
    }

    /**
     * <p>
     * Reports impaired functionality that stems from issues internal to the instance, such as impaired reachability.
     * </p>
     * 
     * @return Reports impaired functionality that stems from issues internal to the instance, such as impaired
     *         reachability.
     */
    public InstanceStatusSummary instanceStatus() {
        return instanceStatus;
    }

    /**
     * <p>
     * Reports impaired functionality that stems from issues related to the systems that support an instance, such as
     * hardware failures and network connectivity problems.
     * </p>
     * 
     * @return Reports impaired functionality that stems from issues related to the systems that support an instance,
     *         such as hardware failures and network connectivity problems.
     */
    public InstanceStatusSummary systemStatus() {
        return systemStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((events() == null) ? 0 : events().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((instanceState() == null) ? 0 : instanceState().hashCode());
        hashCode = 31 * hashCode + ((instanceStatus() == null) ? 0 : instanceStatus().hashCode());
        hashCode = 31 * hashCode + ((systemStatus() == null) ? 0 : systemStatus().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatus)) {
            return false;
        }
        InstanceStatus other = (InstanceStatus) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceState() == null ^ this.instanceState() == null) {
            return false;
        }
        if (other.instanceState() != null && !other.instanceState().equals(this.instanceState())) {
            return false;
        }
        if (other.instanceStatus() == null ^ this.instanceStatus() == null) {
            return false;
        }
        if (other.instanceStatus() != null && !other.instanceStatus().equals(this.instanceStatus())) {
            return false;
        }
        if (other.systemStatus() == null ^ this.systemStatus() == null) {
            return false;
        }
        if (other.systemStatus() != null && !other.systemStatus().equals(this.systemStatus())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (events() != null) {
            sb.append("Events: ").append(events()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceState() != null) {
            sb.append("InstanceState: ").append(instanceState()).append(",");
        }
        if (instanceStatus() != null) {
            sb.append("InstanceStatus: ").append(instanceStatus()).append(",");
        }
        if (systemStatus() != null) {
            sb.append("SystemStatus: ").append(systemStatus()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "Events":
            return Optional.of(clazz.cast(events()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "InstanceState":
            return Optional.of(clazz.cast(instanceState()));
        case "InstanceStatus":
            return Optional.of(clazz.cast(instanceStatus()));
        case "SystemStatus":
            return Optional.of(clazz.cast(systemStatus()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceStatus> {
        /**
         * <p>
         * The Availability Zone of the instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Any scheduled events associated with the instance.
         * </p>
         * 
         * @param events
         *        Any scheduled events associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<InstanceStatusEvent> events);

        /**
         * <p>
         * Any scheduled events associated with the instance.
         * </p>
         * 
         * @param events
         *        Any scheduled events associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(InstanceStatusEvent... events);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The intended state of the instance. <a>DescribeInstanceStatus</a> requires that an instance be in the
         * <code>running</code> state.
         * </p>
         * 
         * @param instanceState
         *        The intended state of the instance. <a>DescribeInstanceStatus</a> requires that an instance be in the
         *        <code>running</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceState(InstanceState instanceState);

        /**
         * <p>
         * Reports impaired functionality that stems from issues internal to the instance, such as impaired
         * reachability.
         * </p>
         * 
         * @param instanceStatus
         *        Reports impaired functionality that stems from issues internal to the instance, such as impaired
         *        reachability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatus(InstanceStatusSummary instanceStatus);

        /**
         * <p>
         * Reports impaired functionality that stems from issues related to the systems that support an instance, such
         * as hardware failures and network connectivity problems.
         * </p>
         * 
         * @param systemStatus
         *        Reports impaired functionality that stems from issues related to the systems that support an instance,
         *        such as hardware failures and network connectivity problems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemStatus(InstanceStatusSummary systemStatus);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private List<InstanceStatusEvent> events;

        private String instanceId;

        private InstanceState instanceState;

        private InstanceStatusSummary instanceStatus;

        private InstanceStatusSummary systemStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatus model) {
            availabilityZone(model.availabilityZone);
            events(model.events);
            instanceId(model.instanceId);
            instanceState(model.instanceState);
            instanceStatus(model.instanceStatus);
            systemStatus(model.systemStatus);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<InstanceStatusEvent.Builder> getEvents() {
            return events != null ? events.stream().map(InstanceStatusEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<InstanceStatusEvent> events) {
            this.events = InstanceStatusEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(InstanceStatusEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<InstanceStatusEvent.BuilderImpl> events) {
            this.events = InstanceStatusEventListCopier.copyFromBuilder(events);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final InstanceState.Builder getInstanceState() {
            return instanceState != null ? instanceState.toBuilder() : null;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public final void setInstanceState(InstanceState.BuilderImpl instanceState) {
            this.instanceState = instanceState != null ? instanceState.build() : null;
        }

        public final InstanceStatusSummary.Builder getInstanceStatus() {
            return instanceStatus != null ? instanceStatus.toBuilder() : null;
        }

        @Override
        public final Builder instanceStatus(InstanceStatusSummary instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public final void setInstanceStatus(InstanceStatusSummary.BuilderImpl instanceStatus) {
            this.instanceStatus = instanceStatus != null ? instanceStatus.build() : null;
        }

        public final InstanceStatusSummary.Builder getSystemStatus() {
            return systemStatus != null ? systemStatus.toBuilder() : null;
        }

        @Override
        public final Builder systemStatus(InstanceStatusSummary systemStatus) {
            this.systemStatus = systemStatus;
            return this;
        }

        public final void setSystemStatus(InstanceStatusSummary.BuilderImpl systemStatus) {
            this.systemStatus = systemStatus != null ? systemStatus.build() : null;
        }

        @Override
        public InstanceStatus build() {
            return new InstanceStatus(this);
        }
    }
}
