/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceStatusSummary implements ToCopyableBuilder<InstanceStatusSummary.Builder, InstanceStatusSummary> {
    private final List<InstanceStatusDetails> details;

    private final String status;

    private InstanceStatusSummary(BuilderImpl builder) {
        this.details = builder.details;
        this.status = builder.status;
    }

    /**
     * <p>
     * The system instance health or application instance health.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The system instance health or application instance health.
     */
    public List<InstanceStatusDetails> details() {
        return details;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SummaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status.
     * @see SummaryStatus
     */
    public SummaryStatus status() {
        return SummaryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SummaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status.
     * @see SummaryStatus
     */
    public String statusString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((details() == null) ? 0 : details().hashCode());
        hashCode = 31 * hashCode + ((statusString() == null) ? 0 : statusString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatusSummary)) {
            return false;
        }
        InstanceStatusSummary other = (InstanceStatusSummary) obj;
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (details() != null) {
            sb.append("Details: ").append(details()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Details":
            return Optional.of(clazz.cast(details()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceStatusSummary> {
        /**
         * <p>
         * The system instance health or application instance health.
         * </p>
         * 
         * @param details
         *        The system instance health or application instance health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<InstanceStatusDetails> details);

        /**
         * <p>
         * The system instance health or application instance health.
         * </p>
         * 
         * @param details
         *        The system instance health or application instance health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(InstanceStatusDetails... details);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see SummaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see SummaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryStatus
         */
        Builder status(SummaryStatus status);
    }

    static final class BuilderImpl implements Builder {
        private List<InstanceStatusDetails> details;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatusSummary model) {
            details(model.details);
            status(model.status);
        }

        public final Collection<InstanceStatusDetails.Builder> getDetails() {
            return details != null ? details.stream().map(InstanceStatusDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder details(Collection<InstanceStatusDetails> details) {
            this.details = InstanceStatusDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(InstanceStatusDetails... details) {
            details(Arrays.asList(details));
            return this;
        }

        public final void setDetails(Collection<InstanceStatusDetails.BuilderImpl> details) {
            this.details = InstanceStatusDetailsListCopier.copyFromBuilder(details);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SummaryStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public InstanceStatusSummary build() {
            return new InstanceStatusSummary(this);
        }
    }
}
