/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an IPv4 range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IpRange implements ToCopyableBuilder<IpRange.Builder, IpRange> {
    private final String cidrIp;

    private IpRange(BuilderImpl builder) {
        this.cidrIp = builder.cidrIp;
    }

    /**
     * <p>
     * The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a
     * single IPv4 address, use the /32 prefix.
     * </p>
     * 
     * @return The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify
     *         a single IPv4 address, use the /32 prefix.
     */
    public String cidrIp() {
        return cidrIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((cidrIp() == null) ? 0 : cidrIp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpRange)) {
            return false;
        }
        IpRange other = (IpRange) obj;
        if (other.cidrIp() == null ^ this.cidrIp() == null) {
            return false;
        }
        if (other.cidrIp() != null && !other.cidrIp().equals(this.cidrIp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cidrIp() != null) {
            sb.append("CidrIp: ").append(cidrIp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrIp":
            return Optional.of(clazz.cast(cidrIp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, IpRange> {
        /**
         * <p>
         * The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To specify a
         * single IPv4 address, use the /32 prefix.
         * </p>
         * 
         * @param cidrIp
         *        The IPv4 CIDR range. You can either specify a CIDR range or a source security group, not both. To
         *        specify a single IPv4 address, use the /32 prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);
    }

    static final class BuilderImpl implements Builder {
        private String cidrIp;

        private BuilderImpl() {
        }

        private BuilderImpl(IpRange model) {
            cidrIp(model.cidrIp);
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        @Override
        public IpRange build() {
            return new IpRange(this);
        }
    }
}
