/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch permission modification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LaunchPermissionModifications implements
        ToCopyableBuilder<LaunchPermissionModifications.Builder, LaunchPermissionModifications> {
    private final List<LaunchPermission> add;

    private final List<LaunchPermission> remove;

    private LaunchPermissionModifications(BuilderImpl builder) {
        this.add = builder.add;
        this.remove = builder.remove;
    }

    /**
     * <p>
     * The AWS account ID to add to the list of launch permissions for the AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The AWS account ID to add to the list of launch permissions for the AMI.
     */
    public List<LaunchPermission> add() {
        return add;
    }

    /**
     * <p>
     * The AWS account ID to remove from the list of launch permissions for the AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The AWS account ID to remove from the list of launch permissions for the AMI.
     */
    public List<LaunchPermission> remove() {
        return remove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((add() == null) ? 0 : add().hashCode());
        hashCode = 31 * hashCode + ((remove() == null) ? 0 : remove().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPermissionModifications)) {
            return false;
        }
        LaunchPermissionModifications other = (LaunchPermissionModifications) obj;
        if (other.add() == null ^ this.add() == null) {
            return false;
        }
        if (other.add() != null && !other.add().equals(this.add())) {
            return false;
        }
        if (other.remove() == null ^ this.remove() == null) {
            return false;
        }
        if (other.remove() != null && !other.remove().equals(this.remove())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (add() != null) {
            sb.append("Add: ").append(add()).append(",");
        }
        if (remove() != null) {
            sb.append("Remove: ").append(remove()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Add":
            return Optional.of(clazz.cast(add()));
        case "Remove":
            return Optional.of(clazz.cast(remove()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LaunchPermissionModifications> {
        /**
         * <p>
         * The AWS account ID to add to the list of launch permissions for the AMI.
         * </p>
         * 
         * @param add
         *        The AWS account ID to add to the list of launch permissions for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(Collection<LaunchPermission> add);

        /**
         * <p>
         * The AWS account ID to add to the list of launch permissions for the AMI.
         * </p>
         * 
         * @param add
         *        The AWS account ID to add to the list of launch permissions for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(LaunchPermission... add);

        /**
         * <p>
         * The AWS account ID to remove from the list of launch permissions for the AMI.
         * </p>
         * 
         * @param remove
         *        The AWS account ID to remove from the list of launch permissions for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(Collection<LaunchPermission> remove);

        /**
         * <p>
         * The AWS account ID to remove from the list of launch permissions for the AMI.
         * </p>
         * 
         * @param remove
         *        The AWS account ID to remove from the list of launch permissions for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(LaunchPermission... remove);
    }

    static final class BuilderImpl implements Builder {
        private List<LaunchPermission> add;

        private List<LaunchPermission> remove;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPermissionModifications model) {
            add(model.add);
            remove(model.remove);
        }

        public final Collection<LaunchPermission.Builder> getAdd() {
            return add != null ? add.stream().map(LaunchPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder add(Collection<LaunchPermission> add) {
            this.add = LaunchPermissionListCopier.copy(add);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(LaunchPermission... add) {
            add(Arrays.asList(add));
            return this;
        }

        public final void setAdd(Collection<LaunchPermission.BuilderImpl> add) {
            this.add = LaunchPermissionListCopier.copyFromBuilder(add);
        }

        public final Collection<LaunchPermission.Builder> getRemove() {
            return remove != null ? remove.stream().map(LaunchPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remove(Collection<LaunchPermission> remove) {
            this.remove = LaunchPermissionListCopier.copy(remove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(LaunchPermission... remove) {
            remove(Arrays.asList(remove));
            return this;
        }

        public final void setRemove(Collection<LaunchPermission.BuilderImpl> remove) {
            this.remove = LaunchPermissionListCopier.copyFromBuilder(remove);
        }

        @Override
        public LaunchPermissionModifications build() {
            return new LaunchPermissionModifications(this);
        }
    }
}
