/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reserved. If you need to sustain traffic greater than the <a
 * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact us
 * through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ProvisionedBandwidth implements ToCopyableBuilder<ProvisionedBandwidth.Builder, ProvisionedBandwidth> {
    private final Instant provisionTime;

    private final String provisioned;

    private final Instant requestTime;

    private final String requested;

    private final String status;

    private ProvisionedBandwidth(BuilderImpl builder) {
        this.provisionTime = builder.provisionTime;
        this.provisioned = builder.provisioned;
        this.requestTime = builder.requestTime;
        this.requested = builder.requested;
        this.status = builder.status;
    }

    /**
     * <p>
     * Reserved. If you need to sustain traffic greater than the <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact
     * us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
     * </p>
     * 
     * @return Reserved. If you need to sustain traffic greater than the <a
     *         href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>,
     *         contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
     */
    public Instant provisionTime() {
        return provisionTime;
    }

    /**
     * <p>
     * Reserved. If you need to sustain traffic greater than the <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact
     * us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
     * </p>
     * 
     * @return Reserved. If you need to sustain traffic greater than the <a
     *         href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>,
     *         contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
     */
    public String provisioned() {
        return provisioned;
    }

    /**
     * <p>
     * Reserved. If you need to sustain traffic greater than the <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact
     * us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
     * </p>
     * 
     * @return Reserved. If you need to sustain traffic greater than the <a
     *         href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>,
     *         contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
     */
    public Instant requestTime() {
        return requestTime;
    }

    /**
     * <p>
     * Reserved. If you need to sustain traffic greater than the <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact
     * us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
     * </p>
     * 
     * @return Reserved. If you need to sustain traffic greater than the <a
     *         href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>,
     *         contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
     */
    public String requested() {
        return requested;
    }

    /**
     * <p>
     * Reserved. If you need to sustain traffic greater than the <a
     * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>, contact
     * us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
     * </p>
     * 
     * @return Reserved. If you need to sustain traffic greater than the <a
     *         href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>,
     *         contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((provisionTime() == null) ? 0 : provisionTime().hashCode());
        hashCode = 31 * hashCode + ((provisioned() == null) ? 0 : provisioned().hashCode());
        hashCode = 31 * hashCode + ((requestTime() == null) ? 0 : requestTime().hashCode());
        hashCode = 31 * hashCode + ((requested() == null) ? 0 : requested().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedBandwidth)) {
            return false;
        }
        ProvisionedBandwidth other = (ProvisionedBandwidth) obj;
        if (other.provisionTime() == null ^ this.provisionTime() == null) {
            return false;
        }
        if (other.provisionTime() != null && !other.provisionTime().equals(this.provisionTime())) {
            return false;
        }
        if (other.provisioned() == null ^ this.provisioned() == null) {
            return false;
        }
        if (other.provisioned() != null && !other.provisioned().equals(this.provisioned())) {
            return false;
        }
        if (other.requestTime() == null ^ this.requestTime() == null) {
            return false;
        }
        if (other.requestTime() != null && !other.requestTime().equals(this.requestTime())) {
            return false;
        }
        if (other.requested() == null ^ this.requested() == null) {
            return false;
        }
        if (other.requested() != null && !other.requested().equals(this.requested())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (provisionTime() != null) {
            sb.append("ProvisionTime: ").append(provisionTime()).append(",");
        }
        if (provisioned() != null) {
            sb.append("Provisioned: ").append(provisioned()).append(",");
        }
        if (requestTime() != null) {
            sb.append("RequestTime: ").append(requestTime()).append(",");
        }
        if (requested() != null) {
            sb.append("Requested: ").append(requested()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProvisionTime":
            return Optional.of(clazz.cast(provisionTime()));
        case "Provisioned":
            return Optional.of(clazz.cast(provisioned()));
        case "RequestTime":
            return Optional.of(clazz.cast(requestTime()));
        case "Requested":
            return Optional.of(clazz.cast(requested()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ProvisionedBandwidth> {
        /**
         * <p>
         * Reserved. If you need to sustain traffic greater than the <a
         * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>,
         * contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
         * </p>
         * 
         * @param provisionTime
         *        Reserved. If you need to sustain traffic greater than the <a
         *        href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented
         *        limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support
         *        Center</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionTime(Instant provisionTime);

        /**
         * <p>
         * Reserved. If you need to sustain traffic greater than the <a
         * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>,
         * contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
         * </p>
         * 
         * @param provisioned
         *        Reserved. If you need to sustain traffic greater than the <a
         *        href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented
         *        limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support
         *        Center</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioned(String provisioned);

        /**
         * <p>
         * Reserved. If you need to sustain traffic greater than the <a
         * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>,
         * contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
         * </p>
         * 
         * @param requestTime
         *        Reserved. If you need to sustain traffic greater than the <a
         *        href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented
         *        limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support
         *        Center</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTime(Instant requestTime);

        /**
         * <p>
         * Reserved. If you need to sustain traffic greater than the <a
         * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>,
         * contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
         * </p>
         * 
         * @param requested
         *        Reserved. If you need to sustain traffic greater than the <a
         *        href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented
         *        limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support
         *        Center</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requested(String requested);

        /**
         * <p>
         * Reserved. If you need to sustain traffic greater than the <a
         * href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented limits</a>,
         * contact us through the <a href="https://console.aws.amazon.com/support/home?">Support Center</a>.
         * </p>
         * 
         * @param status
         *        Reserved. If you need to sustain traffic greater than the <a
         *        href="http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html">documented
         *        limits</a>, contact us through the <a href="https://console.aws.amazon.com/support/home?">Support
         *        Center</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private Instant provisionTime;

        private String provisioned;

        private Instant requestTime;

        private String requested;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedBandwidth model) {
            provisionTime(model.provisionTime);
            provisioned(model.provisioned);
            requestTime(model.requestTime);
            requested(model.requested);
            status(model.status);
        }

        public final Instant getProvisionTime() {
            return provisionTime;
        }

        @Override
        public final Builder provisionTime(Instant provisionTime) {
            this.provisionTime = provisionTime;
            return this;
        }

        public final void setProvisionTime(Instant provisionTime) {
            this.provisionTime = provisionTime;
        }

        public final String getProvisioned() {
            return provisioned;
        }

        @Override
        public final Builder provisioned(String provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final void setProvisioned(String provisioned) {
            this.provisioned = provisioned;
        }

        public final Instant getRequestTime() {
            return requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        public final String getRequested() {
            return requested;
        }

        @Override
        public final Builder requested(String requested) {
            this.requested = requested;
            return this;
        }

        public final void setRequested(String requested) {
            this.requested = requested;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public ProvisionedBandwidth build() {
            return new ProvisionedBandwidth(this);
        }
    }
}
