/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the result of the purchase.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Purchase implements ToCopyableBuilder<Purchase.Builder, Purchase> {
    private final String currencyCode;

    private final Integer duration;

    private final List<String> hostIdSet;

    private final String hostReservationId;

    private final String hourlyPrice;

    private final String instanceFamily;

    private final String paymentOption;

    private final String upfrontPrice;

    private Purchase(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.hostIdSet = builder.hostIdSet;
        this.hostReservationId = builder.hostReservationId;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.paymentOption = builder.paymentOption;
        this.upfrontPrice = builder.upfrontPrice;
    }

    /**
     * <p>
     * The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified. At this
     * time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified.
     *         At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified. At this
     * time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified.
     *         At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeString() {
        return currencyCode;
    }

    /**
     * <p>
     * The duration of the reservation's term in seconds.
     * </p>
     * 
     * @return The duration of the reservation's term in seconds.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts associated with the reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts associated with the reservation.
     */
    public List<String> hostIdSet() {
        return hostIdSet;
    }

    /**
     * <p>
     * The ID of the reservation.
     * </p>
     * 
     * @return The ID of the reservation.
     */
    public String hostReservationId() {
        return hostReservationId;
    }

    /**
     * <p>
     * The hourly price of the reservation per hour.
     * </p>
     * 
     * @return The hourly price of the reservation per hour.
     */
    public String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The instance family on the Dedicated Host that the reservation can be associated with.
     * </p>
     * 
     * @return The instance family on the Dedicated Host that the reservation can be associated with.
     */
    public String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The payment option for the reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionString}.
     * </p>
     * 
     * @return The payment option for the reservation.
     * @see PaymentOption
     */
    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option for the reservation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionString}.
     * </p>
     * 
     * @return The payment option for the reservation.
     * @see PaymentOption
     */
    public String paymentOptionString() {
        return paymentOption;
    }

    /**
     * <p>
     * The upfront price of the reservation.
     * </p>
     * 
     * @return The upfront price of the reservation.
     */
    public String upfrontPrice() {
        return upfrontPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((currencyCodeString() == null) ? 0 : currencyCodeString().hashCode());
        hashCode = 31 * hashCode + ((duration() == null) ? 0 : duration().hashCode());
        hashCode = 31 * hashCode + ((hostIdSet() == null) ? 0 : hostIdSet().hashCode());
        hashCode = 31 * hashCode + ((hostReservationId() == null) ? 0 : hostReservationId().hashCode());
        hashCode = 31 * hashCode + ((hourlyPrice() == null) ? 0 : hourlyPrice().hashCode());
        hashCode = 31 * hashCode + ((instanceFamily() == null) ? 0 : instanceFamily().hashCode());
        hashCode = 31 * hashCode + ((paymentOptionString() == null) ? 0 : paymentOptionString().hashCode());
        hashCode = 31 * hashCode + ((upfrontPrice() == null) ? 0 : upfrontPrice().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Purchase)) {
            return false;
        }
        Purchase other = (Purchase) obj;
        if (other.currencyCodeString() == null ^ this.currencyCodeString() == null) {
            return false;
        }
        if (other.currencyCodeString() != null && !other.currencyCodeString().equals(this.currencyCodeString())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.hostIdSet() == null ^ this.hostIdSet() == null) {
            return false;
        }
        if (other.hostIdSet() != null && !other.hostIdSet().equals(this.hostIdSet())) {
            return false;
        }
        if (other.hostReservationId() == null ^ this.hostReservationId() == null) {
            return false;
        }
        if (other.hostReservationId() != null && !other.hostReservationId().equals(this.hostReservationId())) {
            return false;
        }
        if (other.hourlyPrice() == null ^ this.hourlyPrice() == null) {
            return false;
        }
        if (other.hourlyPrice() != null && !other.hourlyPrice().equals(this.hourlyPrice())) {
            return false;
        }
        if (other.instanceFamily() == null ^ this.instanceFamily() == null) {
            return false;
        }
        if (other.instanceFamily() != null && !other.instanceFamily().equals(this.instanceFamily())) {
            return false;
        }
        if (other.paymentOptionString() == null ^ this.paymentOptionString() == null) {
            return false;
        }
        if (other.paymentOptionString() != null && !other.paymentOptionString().equals(this.paymentOptionString())) {
            return false;
        }
        if (other.upfrontPrice() == null ^ this.upfrontPrice() == null) {
            return false;
        }
        if (other.upfrontPrice() != null && !other.upfrontPrice().equals(this.upfrontPrice())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (currencyCodeString() != null) {
            sb.append("CurrencyCode: ").append(currencyCodeString()).append(",");
        }
        if (duration() != null) {
            sb.append("Duration: ").append(duration()).append(",");
        }
        if (hostIdSet() != null) {
            sb.append("HostIdSet: ").append(hostIdSet()).append(",");
        }
        if (hostReservationId() != null) {
            sb.append("HostReservationId: ").append(hostReservationId()).append(",");
        }
        if (hourlyPrice() != null) {
            sb.append("HourlyPrice: ").append(hourlyPrice()).append(",");
        }
        if (instanceFamily() != null) {
            sb.append("InstanceFamily: ").append(instanceFamily()).append(",");
        }
        if (paymentOptionString() != null) {
            sb.append("PaymentOption: ").append(paymentOptionString()).append(",");
        }
        if (upfrontPrice() != null) {
            sb.append("UpfrontPrice: ").append(upfrontPrice()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.of(clazz.cast(currencyCodeString()));
        case "Duration":
            return Optional.of(clazz.cast(duration()));
        case "HostIdSet":
            return Optional.of(clazz.cast(hostIdSet()));
        case "HostReservationId":
            return Optional.of(clazz.cast(hostReservationId()));
        case "HourlyPrice":
            return Optional.of(clazz.cast(hourlyPrice()));
        case "InstanceFamily":
            return Optional.of(clazz.cast(instanceFamily()));
        case "PaymentOption":
            return Optional.of(clazz.cast(paymentOptionString()));
        case "UpfrontPrice":
            return Optional.of(clazz.cast(upfrontPrice()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Purchase> {
        /**
         * <p>
         * The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified. At
         * this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are specified. At
         * this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>UpfrontPrice</code> and <code>HourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The duration of the reservation's term in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the reservation's term in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The IDs of the Dedicated Hosts associated with the reservation.
         * </p>
         * 
         * @param hostIdSet
         *        The IDs of the Dedicated Hosts associated with the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(Collection<String> hostIdSet);

        /**
         * <p>
         * The IDs of the Dedicated Hosts associated with the reservation.
         * </p>
         * 
         * @param hostIdSet
         *        The IDs of the Dedicated Hosts associated with the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(String... hostIdSet);

        /**
         * <p>
         * The ID of the reservation.
         * </p>
         * 
         * @param hostReservationId
         *        The ID of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationId(String hostReservationId);

        /**
         * <p>
         * The hourly price of the reservation per hour.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly price of the reservation per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The instance family on the Dedicated Host that the reservation can be associated with.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family on the Dedicated Host that the reservation can be associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The payment option for the reservation.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the reservation.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option for the reservation.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the reservation.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The upfront price of the reservation.
         * </p>
         * 
         * @param upfrontPrice
         *        The upfront price of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontPrice(String upfrontPrice);
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private Integer duration;

        private List<String> hostIdSet;

        private String hostReservationId;

        private String hourlyPrice;

        private String instanceFamily;

        private String paymentOption;

        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(Purchase model) {
            currencyCode(model.currencyCode);
            duration(model.duration);
            hostIdSet(model.hostIdSet);
            hostReservationId(model.hostReservationId);
            hourlyPrice(model.hourlyPrice);
            instanceFamily(model.instanceFamily);
            paymentOption(model.paymentOption);
            upfrontPrice(model.upfrontPrice);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Collection<String> getHostIdSet() {
            return hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String... hostIdSet) {
            hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
        }

        public final String getHostReservationId() {
            return hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final String getUpfrontPrice() {
            return upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        @Override
        public Purchase build() {
            return new Purchase(this);
        }
    }
}
