/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for PurchaseScheduledInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseScheduledInstancesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PurchaseScheduledInstancesRequest.Builder, PurchaseScheduledInstancesRequest> {
    private final String clientToken;

    private final List<PurchaseRequest> purchaseRequests;

    private PurchaseScheduledInstancesRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.purchaseRequests = builder.purchaseRequests;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see
     *         <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * One or more purchase requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more purchase requests.
     */
    public List<PurchaseRequest> purchaseRequests() {
        return purchaseRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        hashCode = 31 * hashCode + ((purchaseRequests() == null) ? 0 : purchaseRequests().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesRequest)) {
            return false;
        }
        PurchaseScheduledInstancesRequest other = (PurchaseScheduledInstancesRequest) obj;
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.purchaseRequests() == null ^ this.purchaseRequests() == null) {
            return false;
        }
        if (other.purchaseRequests() != null && !other.purchaseRequests().equals(this.purchaseRequests())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (purchaseRequests() != null) {
            sb.append("PurchaseRequests: ").append(purchaseRequests()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "PurchaseRequests":
            return Optional.of(clazz.cast(purchaseRequests()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PurchaseScheduledInstancesRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that ensures the idempotency of the request. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that ensures the idempotency of the request. For more information,
         *        see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * One or more purchase requests.
         * </p>
         * 
         * @param purchaseRequests
         *        One or more purchase requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseRequests(Collection<PurchaseRequest> purchaseRequests);

        /**
         * <p>
         * One or more purchase requests.
         * </p>
         * 
         * @param purchaseRequests
         *        One or more purchase requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseRequests(PurchaseRequest... purchaseRequests);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private List<PurchaseRequest> purchaseRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseScheduledInstancesRequest model) {
            clientToken(model.clientToken);
            purchaseRequests(model.purchaseRequests);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<PurchaseRequest.Builder> getPurchaseRequests() {
            return purchaseRequests != null ? purchaseRequests.stream().map(PurchaseRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder purchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copy(purchaseRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchaseRequests(PurchaseRequest... purchaseRequests) {
            purchaseRequests(Arrays.asList(purchaseRequests));
            return this;
        }

        public final void setPurchaseRequests(Collection<PurchaseRequest.BuilderImpl> purchaseRequests) {
            this.purchaseRequests = PurchaseRequestSetCopier.copyFromBuilder(purchaseRequests);
        }

        @Override
        public PurchaseScheduledInstancesRequest build() {
            return new PurchaseScheduledInstancesRequest(this);
        }
    }
}
