/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstances implements ToCopyableBuilder<ReservedInstances.Builder, ReservedInstances> {
    private final String availabilityZone;

    private final Long duration;

    private final Instant end;

    private final Float fixedPrice;

    private final Integer instanceCount;

    private final String instanceType;

    private final String productDescription;

    private final String reservedInstancesId;

    private final Instant start;

    private final String state;

    private final Float usagePrice;

    private final String currencyCode;

    private final String instanceTenancy;

    private final String offeringClass;

    private final String offeringType;

    private final List<RecurringCharge> recurringCharges;

    private final String scope;

    private final List<Tag> tags;

    private ReservedInstances(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.end = builder.end;
        this.fixedPrice = builder.fixedPrice;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.start = builder.start;
        this.state = builder.state;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Availability Zone in which the Reserved Instance can be used.
     * </p>
     * 
     * @return The Availability Zone in which the Reserved Instance can be used.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The duration of the Reserved Instance, in seconds.
     * </p>
     * 
     * @return The duration of the Reserved Instance, in seconds.
     */
    public Long duration() {
        return duration;
    }

    /**
     * <p>
     * The time when the Reserved Instance expires.
     * </p>
     * 
     * @return The time when the Reserved Instance expires.
     */
    public Instant end() {
        return end;
    }

    /**
     * <p>
     * The purchase price of the Reserved Instance.
     * </p>
     * 
     * @return The purchase price of the Reserved Instance.
     */
    public Float fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The number of reservations purchased.
     * </p>
     * 
     * @return The number of reservations purchased.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type on which the Reserved Instance can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type on which the Reserved Instance can be used.
     * @see InstanceType
     */
    public String instanceTypeString() {
        return instanceType;
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public RIProductDescription productDescription() {
        return RIProductDescription.fromValue(productDescription);
    }

    /**
     * <p>
     * The Reserved Instance product platform description.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #productDescription} will return {@link RIProductDescription#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #productDescriptionString}.
     * </p>
     * 
     * @return The Reserved Instance product platform description.
     * @see RIProductDescription
     */
    public String productDescriptionString() {
        return productDescription;
    }

    /**
     * <p>
     * The ID of the Reserved Instance.
     * </p>
     * 
     * @return The ID of the Reserved Instance.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * The date and time the Reserved Instance started.
     * </p>
     * 
     * @return The date and time the Reserved Instance started.
     */
    public Instant start() {
        return start;
    }

    /**
     * <p>
     * The state of the Reserved Instance purchase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReservedInstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the Reserved Instance purchase.
     * @see ReservedInstanceState
     */
    public ReservedInstanceState state() {
        return ReservedInstanceState.fromValue(state);
    }

    /**
     * <p>
     * The state of the Reserved Instance purchase.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ReservedInstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the Reserved Instance purchase.
     * @see ReservedInstanceState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The usage price of the Reserved Instance, per hour.
     * </p>
     * 
     * @return The usage price of the Reserved Instance, per hour.
     */
    public Float usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this time, the
     * only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this
     *         time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this time, the
     * only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeString}.
     * </p>
     * 
     * @return The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this
     *         time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeString() {
        return currencyCode;
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyString}.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(instanceTenancy);
    }

    /**
     * <p>
     * The tenancy of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyString}.
     * </p>
     * 
     * @return The tenancy of the instance.
     * @see Tenancy
     */
    public String instanceTenancyString() {
        return instanceTenancy;
    }

    /**
     * <p>
     * The offering class of the Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassString}.
     * </p>
     * 
     * @return The offering class of the Reserved Instance.
     * @see OfferingClassType
     */
    public OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(offeringClass);
    }

    /**
     * <p>
     * The offering class of the Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringClass}
     * will return {@link OfferingClassType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #offeringClassString}.
     * </p>
     * 
     * @return The offering class of the Reserved Instance.
     * @see OfferingClassType
     */
    public String offeringClassString() {
        return offeringClass;
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeString}.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(offeringType);
    }

    /**
     * <p>
     * The Reserved Instance offering type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #offeringType} will
     * return {@link OfferingTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #offeringTypeString}.
     * </p>
     * 
     * @return The Reserved Instance offering type.
     * @see OfferingTypeValues
     */
    public String offeringTypeString() {
        return offeringType;
    }

    /**
     * <p>
     * The recurring charge tag assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The recurring charge tag assigned to the resource.
     */
    public List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    /**
     * <p>
     * The scope of the Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeString}.
     * </p>
     * 
     * @return The scope of the Reserved Instance.
     * @see Scope
     */
    public Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * The scope of the Reserved Instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeString}.
     * </p>
     * 
     * @return The scope of the Reserved Instance.
     * @see Scope
     */
    public String scopeString() {
        return scope;
    }

    /**
     * <p>
     * Any tags assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((duration() == null) ? 0 : duration().hashCode());
        hashCode = 31 * hashCode + ((end() == null) ? 0 : end().hashCode());
        hashCode = 31 * hashCode + ((fixedPrice() == null) ? 0 : fixedPrice().hashCode());
        hashCode = 31 * hashCode + ((instanceCount() == null) ? 0 : instanceCount().hashCode());
        hashCode = 31 * hashCode + ((instanceTypeString() == null) ? 0 : instanceTypeString().hashCode());
        hashCode = 31 * hashCode + ((productDescriptionString() == null) ? 0 : productDescriptionString().hashCode());
        hashCode = 31 * hashCode + ((reservedInstancesId() == null) ? 0 : reservedInstancesId().hashCode());
        hashCode = 31 * hashCode + ((start() == null) ? 0 : start().hashCode());
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        hashCode = 31 * hashCode + ((usagePrice() == null) ? 0 : usagePrice().hashCode());
        hashCode = 31 * hashCode + ((currencyCodeString() == null) ? 0 : currencyCodeString().hashCode());
        hashCode = 31 * hashCode + ((instanceTenancyString() == null) ? 0 : instanceTenancyString().hashCode());
        hashCode = 31 * hashCode + ((offeringClassString() == null) ? 0 : offeringClassString().hashCode());
        hashCode = 31 * hashCode + ((offeringTypeString() == null) ? 0 : offeringTypeString().hashCode());
        hashCode = 31 * hashCode + ((recurringCharges() == null) ? 0 : recurringCharges().hashCode());
        hashCode = 31 * hashCode + ((scopeString() == null) ? 0 : scopeString().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstances)) {
            return false;
        }
        ReservedInstances other = (ReservedInstances) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.end() == null ^ this.end() == null) {
            return false;
        }
        if (other.end() != null && !other.end().equals(this.end())) {
            return false;
        }
        if (other.fixedPrice() == null ^ this.fixedPrice() == null) {
            return false;
        }
        if (other.fixedPrice() != null && !other.fixedPrice().equals(this.fixedPrice())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.instanceTypeString() == null ^ this.instanceTypeString() == null) {
            return false;
        }
        if (other.instanceTypeString() != null && !other.instanceTypeString().equals(this.instanceTypeString())) {
            return false;
        }
        if (other.productDescriptionString() == null ^ this.productDescriptionString() == null) {
            return false;
        }
        if (other.productDescriptionString() != null && !other.productDescriptionString().equals(this.productDescriptionString())) {
            return false;
        }
        if (other.reservedInstancesId() == null ^ this.reservedInstancesId() == null) {
            return false;
        }
        if (other.reservedInstancesId() != null && !other.reservedInstancesId().equals(this.reservedInstancesId())) {
            return false;
        }
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        if (other.start() != null && !other.start().equals(this.start())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.usagePrice() == null ^ this.usagePrice() == null) {
            return false;
        }
        if (other.usagePrice() != null && !other.usagePrice().equals(this.usagePrice())) {
            return false;
        }
        if (other.currencyCodeString() == null ^ this.currencyCodeString() == null) {
            return false;
        }
        if (other.currencyCodeString() != null && !other.currencyCodeString().equals(this.currencyCodeString())) {
            return false;
        }
        if (other.instanceTenancyString() == null ^ this.instanceTenancyString() == null) {
            return false;
        }
        if (other.instanceTenancyString() != null && !other.instanceTenancyString().equals(this.instanceTenancyString())) {
            return false;
        }
        if (other.offeringClassString() == null ^ this.offeringClassString() == null) {
            return false;
        }
        if (other.offeringClassString() != null && !other.offeringClassString().equals(this.offeringClassString())) {
            return false;
        }
        if (other.offeringTypeString() == null ^ this.offeringTypeString() == null) {
            return false;
        }
        if (other.offeringTypeString() != null && !other.offeringTypeString().equals(this.offeringTypeString())) {
            return false;
        }
        if (other.recurringCharges() == null ^ this.recurringCharges() == null) {
            return false;
        }
        if (other.recurringCharges() != null && !other.recurringCharges().equals(this.recurringCharges())) {
            return false;
        }
        if (other.scopeString() == null ^ this.scopeString() == null) {
            return false;
        }
        if (other.scopeString() != null && !other.scopeString().equals(this.scopeString())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (duration() != null) {
            sb.append("Duration: ").append(duration()).append(",");
        }
        if (end() != null) {
            sb.append("End: ").append(end()).append(",");
        }
        if (fixedPrice() != null) {
            sb.append("FixedPrice: ").append(fixedPrice()).append(",");
        }
        if (instanceCount() != null) {
            sb.append("InstanceCount: ").append(instanceCount()).append(",");
        }
        if (instanceTypeString() != null) {
            sb.append("InstanceType: ").append(instanceTypeString()).append(",");
        }
        if (productDescriptionString() != null) {
            sb.append("ProductDescription: ").append(productDescriptionString()).append(",");
        }
        if (reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(reservedInstancesId()).append(",");
        }
        if (start() != null) {
            sb.append("Start: ").append(start()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (usagePrice() != null) {
            sb.append("UsagePrice: ").append(usagePrice()).append(",");
        }
        if (currencyCodeString() != null) {
            sb.append("CurrencyCode: ").append(currencyCodeString()).append(",");
        }
        if (instanceTenancyString() != null) {
            sb.append("InstanceTenancy: ").append(instanceTenancyString()).append(",");
        }
        if (offeringClassString() != null) {
            sb.append("OfferingClass: ").append(offeringClassString()).append(",");
        }
        if (offeringTypeString() != null) {
            sb.append("OfferingType: ").append(offeringTypeString()).append(",");
        }
        if (recurringCharges() != null) {
            sb.append("RecurringCharges: ").append(recurringCharges()).append(",");
        }
        if (scopeString() != null) {
            sb.append("Scope: ").append(scopeString()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "Duration":
            return Optional.of(clazz.cast(duration()));
        case "End":
            return Optional.of(clazz.cast(end()));
        case "FixedPrice":
            return Optional.of(clazz.cast(fixedPrice()));
        case "InstanceCount":
            return Optional.of(clazz.cast(instanceCount()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceTypeString()));
        case "ProductDescription":
            return Optional.of(clazz.cast(productDescriptionString()));
        case "ReservedInstancesId":
            return Optional.of(clazz.cast(reservedInstancesId()));
        case "Start":
            return Optional.of(clazz.cast(start()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "UsagePrice":
            return Optional.of(clazz.cast(usagePrice()));
        case "CurrencyCode":
            return Optional.of(clazz.cast(currencyCodeString()));
        case "InstanceTenancy":
            return Optional.of(clazz.cast(instanceTenancyString()));
        case "OfferingClass":
            return Optional.of(clazz.cast(offeringClassString()));
        case "OfferingType":
            return Optional.of(clazz.cast(offeringTypeString()));
        case "RecurringCharges":
            return Optional.of(clazz.cast(recurringCharges()));
        case "Scope":
            return Optional.of(clazz.cast(scopeString()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstances> {
        /**
         * <p>
         * The Availability Zone in which the Reserved Instance can be used.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the Reserved Instance can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The duration of the Reserved Instance, in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the Reserved Instance, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * The time when the Reserved Instance expires.
         * </p>
         * 
         * @param end
         *        The time when the Reserved Instance expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);

        /**
         * <p>
         * The purchase price of the Reserved Instance.
         * </p>
         * 
         * @param fixedPrice
         *        The purchase price of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Float fixedPrice);

        /**
         * <p>
         * The number of reservations purchased.
         * </p>
         * 
         * @param instanceCount
         *        The number of reservations purchased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type on which the Reserved Instance can be used.
         * </p>
         * 
         * @param instanceType
         *        The instance type on which the Reserved Instance can be used.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The Reserved Instance product platform description.
         * </p>
         * 
         * @param productDescription
         *        The Reserved Instance product platform description.
         * @see RIProductDescription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RIProductDescription
         */
        Builder productDescription(RIProductDescription productDescription);

        /**
         * <p>
         * The ID of the Reserved Instance.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * The date and time the Reserved Instance started.
         * </p>
         * 
         * @param start
         *        The date and time the Reserved Instance started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The state of the Reserved Instance purchase.
         * </p>
         * 
         * @param state
         *        The state of the Reserved Instance purchase.
         * @see ReservedInstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedInstanceState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Reserved Instance purchase.
         * </p>
         * 
         * @param state
         *        The state of the Reserved Instance purchase.
         * @see ReservedInstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedInstanceState
         */
        Builder state(ReservedInstanceState state);

        /**
         * <p>
         * The usage price of the Reserved Instance, per hour.
         * </p>
         * 
         * @param usagePrice
         *        The usage price of the Reserved Instance, per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Float usagePrice);

        /**
         * <p>
         * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this time,
         * the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this
         *        time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this time,
         * the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the Reserved Instance. It's specified using ISO 4217 standard currency codes. At this
         *        time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The tenancy of the instance.
         * </p>
         * 
         * @param instanceTenancy
         *        The tenancy of the instance.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * The offering class of the Reserved Instance.
         * </p>
         * 
         * @param offeringClass
         *        The offering class of the Reserved Instance.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(String offeringClass);

        /**
         * <p>
         * The offering class of the Reserved Instance.
         * </p>
         * 
         * @param offeringClass
         *        The offering class of the Reserved Instance.
         * @see OfferingClassType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingClassType
         */
        Builder offeringClass(OfferingClassType offeringClass);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The Reserved Instance offering type.
         * </p>
         * 
         * @param offeringType
         *        The Reserved Instance offering type.
         * @see OfferingTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OfferingTypeValues
         */
        Builder offeringType(OfferingTypeValues offeringType);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The recurring charge tag assigned to the resource.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring charge tag assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The scope of the Reserved Instance.
         * </p>
         * 
         * @param scope
         *        The scope of the Reserved Instance.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope of the Reserved Instance.
         * </p>
         * 
         * @param scope
         *        The scope of the Reserved Instance.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Long duration;

        private Instant end;

        private Float fixedPrice;

        private Integer instanceCount;

        private String instanceType;

        private String productDescription;

        private String reservedInstancesId;

        private Instant start;

        private String state;

        private Float usagePrice;

        private String currencyCode;

        private String instanceTenancy;

        private String offeringClass;

        private String offeringType;

        private List<RecurringCharge> recurringCharges;

        private String scope;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstances model) {
            availabilityZone(model.availabilityZone);
            duration(model.duration);
            end(model.end);
            fixedPrice(model.fixedPrice);
            instanceCount(model.instanceCount);
            instanceType(model.instanceType);
            productDescription(model.productDescription);
            reservedInstancesId(model.reservedInstancesId);
            start(model.start);
            state(model.state);
            usagePrice(model.usagePrice);
            currencyCode(model.currencyCode);
            instanceTenancy(model.instanceTenancy);
            offeringClass(model.offeringClass);
            offeringType(model.offeringType);
            recurringCharges(model.recurringCharges);
            scope(model.scope);
            tags(model.tags);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Instant getEnd() {
            return end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        public final Float getFixedPrice() {
            return fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final Instant getStart() {
            return start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservedInstanceState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Float getUsagePrice() {
            return usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final String getOfferingClass() {
            return offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return recurringCharges != null ? recurringCharges.stream().map(RecurringCharge::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copyFromBuilder(recurringCharges);
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public ReservedInstances build() {
            return new ReservedInstances(this);
        }
    }
}
