/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance modification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstancesModification implements
        ToCopyableBuilder<ReservedInstancesModification.Builder, ReservedInstancesModification> {
    private final String clientToken;

    private final Instant createDate;

    private final Instant effectiveDate;

    private final List<ReservedInstancesModificationResult> modificationResults;

    private final List<ReservedInstancesId> reservedInstancesIds;

    private final String reservedInstancesModificationId;

    private final String status;

    private final String statusMessage;

    private final Instant updateDate;

    private ReservedInstancesModification(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.effectiveDate = builder.effectiveDate;
        this.modificationResults = builder.modificationResults;
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.reservedInstancesModificationId = builder.reservedInstancesModificationId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.updateDate = builder.updateDate;
    }

    /**
     * <p>
     * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The time when the modification request was created.
     * </p>
     * 
     * @return The time when the modification request was created.
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The time for the modification to become effective.
     * </p>
     * 
     * @return The time for the modification to become effective.
     */
    public Instant effectiveDate() {
        return effectiveDate;
    }

    /**
     * <p>
     * Contains target configurations along with their corresponding new Reserved Instance IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains target configurations along with their corresponding new Reserved Instance IDs.
     */
    public List<ReservedInstancesModificationResult> modificationResults() {
        return modificationResults;
    }

    /**
     * <p>
     * The IDs of one or more Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more Reserved Instances.
     */
    public List<ReservedInstancesId> reservedInstancesIds() {
        return reservedInstancesIds;
    }

    /**
     * <p>
     * A unique ID for the Reserved Instance modification.
     * </p>
     * 
     * @return A unique ID for the Reserved Instance modification.
     */
    public String reservedInstancesModificationId() {
        return reservedInstancesModificationId;
    }

    /**
     * <p>
     * The status of the Reserved Instances modification request.
     * </p>
     * 
     * @return The status of the Reserved Instances modification request.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The reason for the status.
     * </p>
     * 
     * @return The reason for the status.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The time when the modification request was last updated.
     * </p>
     * 
     * @return The time when the modification request was last updated.
     */
    public Instant updateDate() {
        return updateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        hashCode = 31 * hashCode + ((createDate() == null) ? 0 : createDate().hashCode());
        hashCode = 31 * hashCode + ((effectiveDate() == null) ? 0 : effectiveDate().hashCode());
        hashCode = 31 * hashCode + ((modificationResults() == null) ? 0 : modificationResults().hashCode());
        hashCode = 31 * hashCode + ((reservedInstancesIds() == null) ? 0 : reservedInstancesIds().hashCode());
        hashCode = 31 * hashCode
                + ((reservedInstancesModificationId() == null) ? 0 : reservedInstancesModificationId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusMessage() == null) ? 0 : statusMessage().hashCode());
        hashCode = 31 * hashCode + ((updateDate() == null) ? 0 : updateDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesModification)) {
            return false;
        }
        ReservedInstancesModification other = (ReservedInstancesModification) obj;
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.effectiveDate() == null ^ this.effectiveDate() == null) {
            return false;
        }
        if (other.effectiveDate() != null && !other.effectiveDate().equals(this.effectiveDate())) {
            return false;
        }
        if (other.modificationResults() == null ^ this.modificationResults() == null) {
            return false;
        }
        if (other.modificationResults() != null && !other.modificationResults().equals(this.modificationResults())) {
            return false;
        }
        if (other.reservedInstancesIds() == null ^ this.reservedInstancesIds() == null) {
            return false;
        }
        if (other.reservedInstancesIds() != null && !other.reservedInstancesIds().equals(this.reservedInstancesIds())) {
            return false;
        }
        if (other.reservedInstancesModificationId() == null ^ this.reservedInstancesModificationId() == null) {
            return false;
        }
        if (other.reservedInstancesModificationId() != null
                && !other.reservedInstancesModificationId().equals(this.reservedInstancesModificationId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.updateDate() == null ^ this.updateDate() == null) {
            return false;
        }
        if (other.updateDate() != null && !other.updateDate().equals(this.updateDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (createDate() != null) {
            sb.append("CreateDate: ").append(createDate()).append(",");
        }
        if (effectiveDate() != null) {
            sb.append("EffectiveDate: ").append(effectiveDate()).append(",");
        }
        if (modificationResults() != null) {
            sb.append("ModificationResults: ").append(modificationResults()).append(",");
        }
        if (reservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: ").append(reservedInstancesIds()).append(",");
        }
        if (reservedInstancesModificationId() != null) {
            sb.append("ReservedInstancesModificationId: ").append(reservedInstancesModificationId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusMessage() != null) {
            sb.append("StatusMessage: ").append(statusMessage()).append(",");
        }
        if (updateDate() != null) {
            sb.append("UpdateDate: ").append(updateDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "CreateDate":
            return Optional.of(clazz.cast(createDate()));
        case "EffectiveDate":
            return Optional.of(clazz.cast(effectiveDate()));
        case "ModificationResults":
            return Optional.of(clazz.cast(modificationResults()));
        case "ReservedInstancesIds":
            return Optional.of(clazz.cast(reservedInstancesIds()));
        case "ReservedInstancesModificationId":
            return Optional.of(clazz.cast(reservedInstancesModificationId()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "StatusMessage":
            return Optional.of(clazz.cast(statusMessage()));
        case "UpdateDate":
            return Optional.of(clazz.cast(updateDate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstancesModification> {
        /**
         * <p>
         * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The time when the modification request was created.
         * </p>
         * 
         * @param createDate
         *        The time when the modification request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The time for the modification to become effective.
         * </p>
         * 
         * @param effectiveDate
         *        The time for the modification to become effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveDate(Instant effectiveDate);

        /**
         * <p>
         * Contains target configurations along with their corresponding new Reserved Instance IDs.
         * </p>
         * 
         * @param modificationResults
         *        Contains target configurations along with their corresponding new Reserved Instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationResults(Collection<ReservedInstancesModificationResult> modificationResults);

        /**
         * <p>
         * Contains target configurations along with their corresponding new Reserved Instance IDs.
         * </p>
         * 
         * @param modificationResults
         *        Contains target configurations along with their corresponding new Reserved Instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationResults(ReservedInstancesModificationResult... modificationResults);

        /**
         * <p>
         * The IDs of one or more Reserved Instances.
         * </p>
         * 
         * @param reservedInstancesIds
         *        The IDs of one or more Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(Collection<ReservedInstancesId> reservedInstancesIds);

        /**
         * <p>
         * The IDs of one or more Reserved Instances.
         * </p>
         * 
         * @param reservedInstancesIds
         *        The IDs of one or more Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesIds(ReservedInstancesId... reservedInstancesIds);

        /**
         * <p>
         * A unique ID for the Reserved Instance modification.
         * </p>
         * 
         * @param reservedInstancesModificationId
         *        A unique ID for the Reserved Instance modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesModificationId(String reservedInstancesModificationId);

        /**
         * <p>
         * The status of the Reserved Instances modification request.
         * </p>
         * 
         * @param status
         *        The status of the Reserved Instances modification request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The reason for the status.
         * </p>
         * 
         * @param statusMessage
         *        The reason for the status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The time when the modification request was last updated.
         * </p>
         * 
         * @param updateDate
         *        The time when the modification request was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private Instant createDate;

        private Instant effectiveDate;

        private List<ReservedInstancesModificationResult> modificationResults;

        private List<ReservedInstancesId> reservedInstancesIds;

        private String reservedInstancesModificationId;

        private String status;

        private String statusMessage;

        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesModification model) {
            clientToken(model.clientToken);
            createDate(model.createDate);
            effectiveDate(model.effectiveDate);
            modificationResults(model.modificationResults);
            reservedInstancesIds(model.reservedInstancesIds);
            reservedInstancesModificationId(model.reservedInstancesModificationId);
            status(model.status);
            statusMessage(model.statusMessage);
            updateDate(model.updateDate);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getEffectiveDate() {
            return effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final void setEffectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        public final Collection<ReservedInstancesModificationResult.Builder> getModificationResults() {
            return modificationResults != null ? modificationResults.stream().map(ReservedInstancesModificationResult::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modificationResults(Collection<ReservedInstancesModificationResult> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copy(modificationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationResults(ReservedInstancesModificationResult... modificationResults) {
            modificationResults(Arrays.asList(modificationResults));
            return this;
        }

        public final void setModificationResults(Collection<ReservedInstancesModificationResult.BuilderImpl> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copyFromBuilder(modificationResults);
        }

        public final Collection<ReservedInstancesId.Builder> getReservedInstancesIds() {
            return reservedInstancesIds != null ? reservedInstancesIds.stream().map(ReservedInstancesId::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<ReservedInstancesId> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(ReservedInstancesId... reservedInstancesIds) {
            reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final void setReservedInstancesIds(Collection<ReservedInstancesId.BuilderImpl> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copyFromBuilder(reservedInstancesIds);
        }

        public final String getReservedInstancesModificationId() {
            return reservedInstancesModificationId;
        }

        @Override
        public final Builder reservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
            return this;
        }

        public final void setReservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public ReservedInstancesModification build() {
            return new ReservedInstancesModification(this);
        }
    }
}
