/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RevokeSecurityGroupEgress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RevokeSecurityGroupEgressRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RevokeSecurityGroupEgressRequest.Builder, RevokeSecurityGroupEgressRequest> {
    private final String groupId;

    private final List<IpPermission> ipPermissions;

    private final String cidrIp;

    private final Integer fromPort;

    private final String ipProtocol;

    private final Integer toPort;

    private final String sourceSecurityGroupName;

    private final String sourceSecurityGroupOwnerId;

    private RevokeSecurityGroupEgressRequest(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.ipPermissions = builder.ipPermissions;
        this.cidrIp = builder.cidrIp;
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.toPort = builder.toPort;
        this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
        this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * <p>
     * A set of IP permissions. You can't specify a destination security group and a CIDR IP address range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of IP permissions. You can't specify a destination security group and a CIDR IP address range.
     */
    public List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    /**
     * <p>
     * The CIDR IP address range. We recommend that you specify the CIDR range in a set of IP permissions instead.
     * </p>
     * 
     * @return The CIDR IP address range. We recommend that you specify the CIDR range in a set of IP permissions
     *         instead.
     */
    public String cidrIp() {
        return cidrIp;
    }

    /**
     * <p>
     * The start of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you specify the
     * port range in a set of IP permissions instead.
     * </p>
     * 
     * @return The start of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you
     *         specify the port range in a set of IP permissions instead.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The IP protocol name or number. We recommend that you specify the protocol in a set of IP permissions instead.
     * </p>
     * 
     * @return The IP protocol name or number. We recommend that you specify the protocol in a set of IP permissions
     *         instead.
     */
    public String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * The end of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you specify the
     * port range in a set of IP permissions instead.
     * </p>
     * 
     * @return The end of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you
     *         specify the port range in a set of IP permissions instead.
     */
    public Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * The name of a destination security group. To revoke outbound access to a destination security group, we recommend
     * that you use a set of IP permissions instead.
     * </p>
     * 
     * @return The name of a destination security group. To revoke outbound access to a destination security group, we
     *         recommend that you use a set of IP permissions instead.
     */
    public String sourceSecurityGroupName() {
        return sourceSecurityGroupName;
    }

    /**
     * <p>
     * The AWS account number for a destination security group. To revoke outbound access to a destination security
     * group, we recommend that you use a set of IP permissions instead.
     * </p>
     * 
     * @return The AWS account number for a destination security group. To revoke outbound access to a destination
     *         security group, we recommend that you use a set of IP permissions instead.
     */
    public String sourceSecurityGroupOwnerId() {
        return sourceSecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((groupId() == null) ? 0 : groupId().hashCode());
        hashCode = 31 * hashCode + ((ipPermissions() == null) ? 0 : ipPermissions().hashCode());
        hashCode = 31 * hashCode + ((cidrIp() == null) ? 0 : cidrIp().hashCode());
        hashCode = 31 * hashCode + ((fromPort() == null) ? 0 : fromPort().hashCode());
        hashCode = 31 * hashCode + ((ipProtocol() == null) ? 0 : ipProtocol().hashCode());
        hashCode = 31 * hashCode + ((toPort() == null) ? 0 : toPort().hashCode());
        hashCode = 31 * hashCode + ((sourceSecurityGroupName() == null) ? 0 : sourceSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + ((sourceSecurityGroupOwnerId() == null) ? 0 : sourceSecurityGroupOwnerId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSecurityGroupEgressRequest)) {
            return false;
        }
        RevokeSecurityGroupEgressRequest other = (RevokeSecurityGroupEgressRequest) obj;
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.ipPermissions() == null ^ this.ipPermissions() == null) {
            return false;
        }
        if (other.ipPermissions() != null && !other.ipPermissions().equals(this.ipPermissions())) {
            return false;
        }
        if (other.cidrIp() == null ^ this.cidrIp() == null) {
            return false;
        }
        if (other.cidrIp() != null && !other.cidrIp().equals(this.cidrIp())) {
            return false;
        }
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.ipProtocol() == null ^ this.ipProtocol() == null) {
            return false;
        }
        if (other.ipProtocol() != null && !other.ipProtocol().equals(this.ipProtocol())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        if (other.sourceSecurityGroupName() == null ^ this.sourceSecurityGroupName() == null) {
            return false;
        }
        if (other.sourceSecurityGroupName() != null && !other.sourceSecurityGroupName().equals(this.sourceSecurityGroupName())) {
            return false;
        }
        if (other.sourceSecurityGroupOwnerId() == null ^ this.sourceSecurityGroupOwnerId() == null) {
            return false;
        }
        if (other.sourceSecurityGroupOwnerId() != null
                && !other.sourceSecurityGroupOwnerId().equals(this.sourceSecurityGroupOwnerId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (groupId() != null) {
            sb.append("GroupId: ").append(groupId()).append(",");
        }
        if (ipPermissions() != null) {
            sb.append("IpPermissions: ").append(ipPermissions()).append(",");
        }
        if (cidrIp() != null) {
            sb.append("CidrIp: ").append(cidrIp()).append(",");
        }
        if (fromPort() != null) {
            sb.append("FromPort: ").append(fromPort()).append(",");
        }
        if (ipProtocol() != null) {
            sb.append("IpProtocol: ").append(ipProtocol()).append(",");
        }
        if (toPort() != null) {
            sb.append("ToPort: ").append(toPort()).append(",");
        }
        if (sourceSecurityGroupName() != null) {
            sb.append("SourceSecurityGroupName: ").append(sourceSecurityGroupName()).append(",");
        }
        if (sourceSecurityGroupOwnerId() != null) {
            sb.append("SourceSecurityGroupOwnerId: ").append(sourceSecurityGroupOwnerId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.of(clazz.cast(groupId()));
        case "IpPermissions":
            return Optional.of(clazz.cast(ipPermissions()));
        case "CidrIp":
            return Optional.of(clazz.cast(cidrIp()));
        case "FromPort":
            return Optional.of(clazz.cast(fromPort()));
        case "IpProtocol":
            return Optional.of(clazz.cast(ipProtocol()));
        case "ToPort":
            return Optional.of(clazz.cast(toPort()));
        case "SourceSecurityGroupName":
            return Optional.of(clazz.cast(sourceSecurityGroupName()));
        case "SourceSecurityGroupOwnerId":
            return Optional.of(clazz.cast(sourceSecurityGroupOwnerId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RevokeSecurityGroupEgressRequest> {
        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * A set of IP permissions. You can't specify a destination security group and a CIDR IP address range.
         * </p>
         * 
         * @param ipPermissions
         *        A set of IP permissions. You can't specify a destination security group and a CIDR IP address range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * A set of IP permissions. You can't specify a destination security group and a CIDR IP address range.
         * </p>
         * 
         * @param ipPermissions
         *        A set of IP permissions. You can't specify a destination security group and a CIDR IP address range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);

        /**
         * <p>
         * The CIDR IP address range. We recommend that you specify the CIDR range in a set of IP permissions instead.
         * </p>
         * 
         * @param cidrIp
         *        The CIDR IP address range. We recommend that you specify the CIDR range in a set of IP permissions
         *        instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * The start of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you specify
         * the port range in a set of IP permissions instead.
         * </p>
         * 
         * @param fromPort
         *        The start of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you
         *        specify the port range in a set of IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The IP protocol name or number. We recommend that you specify the protocol in a set of IP permissions
         * instead.
         * </p>
         * 
         * @param ipProtocol
         *        The IP protocol name or number. We recommend that you specify the protocol in a set of IP permissions
         *        instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * The end of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you specify
         * the port range in a set of IP permissions instead.
         * </p>
         * 
         * @param toPort
         *        The end of port range for the TCP and UDP protocols, or an ICMP type number. We recommend that you
         *        specify the port range in a set of IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The name of a destination security group. To revoke outbound access to a destination security group, we
         * recommend that you use a set of IP permissions instead.
         * </p>
         * 
         * @param sourceSecurityGroupName
         *        The name of a destination security group. To revoke outbound access to a destination security group,
         *        we recommend that you use a set of IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupName(String sourceSecurityGroupName);

        /**
         * <p>
         * The AWS account number for a destination security group. To revoke outbound access to a destination security
         * group, we recommend that you use a set of IP permissions instead.
         * </p>
         * 
         * @param sourceSecurityGroupOwnerId
         *        The AWS account number for a destination security group. To revoke outbound access to a destination
         *        security group, we recommend that you use a set of IP permissions instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private List<IpPermission> ipPermissions;

        private String cidrIp;

        private Integer fromPort;

        private String ipProtocol;

        private Integer toPort;

        private String sourceSecurityGroupName;

        private String sourceSecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSecurityGroupEgressRequest model) {
            groupId(model.groupId);
            ipPermissions(model.ipPermissions);
            cidrIp(model.cidrIp);
            fromPort(model.fromPort);
            ipProtocol(model.ipProtocol);
            toPort(model.toPort);
            sourceSecurityGroupName(model.sourceSecurityGroupName);
            sourceSecurityGroupOwnerId(model.sourceSecurityGroupOwnerId);
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final Collection<IpPermission.Builder> getIpPermissions() {
            return ipPermissions != null ? ipPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getSourceSecurityGroupName() {
            return sourceSecurityGroupName;
        }

        @Override
        public final Builder sourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
            return this;
        }

        public final void setSourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
        }

        public final String getSourceSecurityGroupOwnerId() {
            return sourceSecurityGroupOwnerId;
        }

        @Override
        public final Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
            return this;
        }

        public final void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
        }

        @Override
        public RevokeSecurityGroupEgressRequest build() {
            return new RevokeSecurityGroupEgressRequest(this);
        }
    }
}
