/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping for a Scheduled Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduledInstancesBlockDeviceMapping implements
        ToCopyableBuilder<ScheduledInstancesBlockDeviceMapping.Builder, ScheduledInstancesBlockDeviceMapping> {
    private final String deviceName;

    private final ScheduledInstancesEbs ebs;

    private final String noDevice;

    private final String virtualName;

    private ScheduledInstancesBlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
    }

    /**
     * <p>
     * The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * 
     * @return The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Parameters used to set up EBS volumes automatically when the instance is launched.
     * </p>
     * 
     * @return Parameters used to set up EBS volumes automatically when the instance is launched.
     */
    public ScheduledInstancesEbs ebs() {
        return ebs;
    }

    /**
     * <p>
     * Suppresses the specified device included in the block device mapping of the AMI.
     * </p>
     * 
     * @return Suppresses the specified device included in the block device mapping of the AMI.
     */
    public String noDevice() {
        return noDevice;
    }

    /**
     * <p>
     * The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An
     * instance type with two available instance store volumes can specify mappings for <code>ephemeral0</code> and
     * <code>ephemeral1</code>.The number of available instance store volumes depends on the instance type. After you
     * connect to the instance, you must mount the volume.
     * </p>
     * <p>
     * Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the
     * instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device
     * mapping for the AMI.
     * </p>
     * 
     * @return The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0.
     *         An instance type with two available instance store volumes can specify mappings for
     *         <code>ephemeral0</code> and <code>ephemeral1</code>.The number of available instance store volumes
     *         depends on the instance type. After you connect to the instance, you must mount the volume.</p>
     *         <p>
     *         Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for
     *         the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block
     *         device mapping for the AMI.
     */
    public String virtualName() {
        return virtualName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deviceName() == null) ? 0 : deviceName().hashCode());
        hashCode = 31 * hashCode + ((ebs() == null) ? 0 : ebs().hashCode());
        hashCode = 31 * hashCode + ((noDevice() == null) ? 0 : noDevice().hashCode());
        hashCode = 31 * hashCode + ((virtualName() == null) ? 0 : virtualName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesBlockDeviceMapping)) {
            return false;
        }
        ScheduledInstancesBlockDeviceMapping other = (ScheduledInstancesBlockDeviceMapping) obj;
        if (other.deviceName() == null ^ this.deviceName() == null) {
            return false;
        }
        if (other.deviceName() != null && !other.deviceName().equals(this.deviceName())) {
            return false;
        }
        if (other.ebs() == null ^ this.ebs() == null) {
            return false;
        }
        if (other.ebs() != null && !other.ebs().equals(this.ebs())) {
            return false;
        }
        if (other.noDevice() == null ^ this.noDevice() == null) {
            return false;
        }
        if (other.noDevice() != null && !other.noDevice().equals(this.noDevice())) {
            return false;
        }
        if (other.virtualName() == null ^ this.virtualName() == null) {
            return false;
        }
        if (other.virtualName() != null && !other.virtualName().equals(this.virtualName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deviceName() != null) {
            sb.append("DeviceName: ").append(deviceName()).append(",");
        }
        if (ebs() != null) {
            sb.append("Ebs: ").append(ebs()).append(",");
        }
        if (noDevice() != null) {
            sb.append("NoDevice: ").append(noDevice()).append(",");
        }
        if (virtualName() != null) {
            sb.append("VirtualName: ").append(virtualName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.of(clazz.cast(deviceName()));
        case "Ebs":
            return Optional.of(clazz.cast(ebs()));
        case "NoDevice":
            return Optional.of(clazz.cast(noDevice()));
        case "VirtualName":
            return Optional.of(clazz.cast(virtualName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduledInstancesBlockDeviceMapping> {
        /**
         * <p>
         * The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * 
         * @param deviceName
         *        The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Parameters used to set up EBS volumes automatically when the instance is launched.
         * </p>
         * 
         * @param ebs
         *        Parameters used to set up EBS volumes automatically when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(ScheduledInstancesEbs ebs);

        /**
         * <p>
         * Suppresses the specified device included in the block device mapping of the AMI.
         * </p>
         * 
         * @param noDevice
         *        Suppresses the specified device included in the block device mapping of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(String noDevice);

        /**
         * <p>
         * The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An
         * instance type with two available instance store volumes can specify mappings for <code>ephemeral0</code> and
         * <code>ephemeral1</code>.The number of available instance store volumes depends on the instance type. After
         * you connect to the instance, you must mount the volume.
         * </p>
         * <p>
         * Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the
         * instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device
         * mapping for the AMI.
         * </p>
         * 
         * @param virtualName
         *        The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from
         *        0. An instance type with two available instance store volumes can specify mappings for
         *        <code>ephemeral0</code> and <code>ephemeral1</code>.The number of available instance store volumes
         *        depends on the instance type. After you connect to the instance, you must mount the volume.</p>
         *        <p>
         *        Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for
         *        the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the
         *        block device mapping for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private ScheduledInstancesEbs ebs;

        private String noDevice;

        private String virtualName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesBlockDeviceMapping model) {
            deviceName(model.deviceName);
            ebs(model.ebs);
            noDevice(model.noDevice);
            virtualName(model.virtualName);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final ScheduledInstancesEbs.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(ScheduledInstancesEbs ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(ScheduledInstancesEbs.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public final String getNoDevice() {
            return noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        @Override
        public ScheduledInstancesBlockDeviceMapping build() {
            return new ScheduledInstancesBlockDeviceMapping(this);
        }
    }
}
