/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC with a security group that references your security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SecurityGroupReference implements ToCopyableBuilder<SecurityGroupReference.Builder, SecurityGroupReference> {
    private final String groupId;

    private final String referencingVpcId;

    private final String vpcPeeringConnectionId;

    private SecurityGroupReference(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.referencingVpcId = builder.referencingVpcId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The ID of your security group.
     * </p>
     * 
     * @return The ID of your security group.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The ID of the VPC with the referencing security group.
     * </p>
     * 
     * @return The ID of the VPC with the referencing security group.
     */
    public String referencingVpcId() {
        return referencingVpcId;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((groupId() == null) ? 0 : groupId().hashCode());
        hashCode = 31 * hashCode + ((referencingVpcId() == null) ? 0 : referencingVpcId().hashCode());
        hashCode = 31 * hashCode + ((vpcPeeringConnectionId() == null) ? 0 : vpcPeeringConnectionId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupReference)) {
            return false;
        }
        SecurityGroupReference other = (SecurityGroupReference) obj;
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.referencingVpcId() == null ^ this.referencingVpcId() == null) {
            return false;
        }
        if (other.referencingVpcId() != null && !other.referencingVpcId().equals(this.referencingVpcId())) {
            return false;
        }
        if (other.vpcPeeringConnectionId() == null ^ this.vpcPeeringConnectionId() == null) {
            return false;
        }
        if (other.vpcPeeringConnectionId() != null && !other.vpcPeeringConnectionId().equals(this.vpcPeeringConnectionId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (groupId() != null) {
            sb.append("GroupId: ").append(groupId()).append(",");
        }
        if (referencingVpcId() != null) {
            sb.append("ReferencingVpcId: ").append(referencingVpcId()).append(",");
        }
        if (vpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: ").append(vpcPeeringConnectionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.of(clazz.cast(groupId()));
        case "ReferencingVpcId":
            return Optional.of(clazz.cast(referencingVpcId()));
        case "VpcPeeringConnectionId":
            return Optional.of(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SecurityGroupReference> {
        /**
         * <p>
         * The ID of your security group.
         * </p>
         * 
         * @param groupId
         *        The ID of your security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The ID of the VPC with the referencing security group.
         * </p>
         * 
         * @param referencingVpcId
         *        The ID of the VPC with the referencing security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencingVpcId(String referencingVpcId);

        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    static final class BuilderImpl implements Builder {
        private String groupId;

        private String referencingVpcId;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupReference model) {
            groupId(model.groupId);
            referencingVpcId(model.referencingVpcId);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getReferencingVpcId() {
            return referencingVpcId;
        }

        @Override
        public final Builder referencingVpcId(String referencingVpcId) {
            this.referencingVpcId = referencingVpcId;
            return this;
        }

        public final void setReferencingVpcId(String referencingVpcId) {
            this.referencingVpcId = referencingVpcId;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public SecurityGroupReference build() {
            return new SecurityGroupReference(this);
        }
    }
}
