/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the time period for a Scheduled Instance to start its first schedule. The time period must span less than
 * one day.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SlotDateTimeRangeRequest implements ToCopyableBuilder<SlotDateTimeRangeRequest.Builder, SlotDateTimeRangeRequest> {
    private final Instant earliestTime;

    private final Instant latestTime;

    private SlotDateTimeRangeRequest(BuilderImpl builder) {
        this.earliestTime = builder.earliestTime;
        this.latestTime = builder.latestTime;
    }

    /**
     * <p>
     * The earliest date and time, in UTC, for the Scheduled Instance to start.
     * </p>
     * 
     * @return The earliest date and time, in UTC, for the Scheduled Instance to start.
     */
    public Instant earliestTime() {
        return earliestTime;
    }

    /**
     * <p>
     * The latest date and time, in UTC, for the Scheduled Instance to start. This value must be later than or equal to
     * the earliest date and at most three months in the future.
     * </p>
     * 
     * @return The latest date and time, in UTC, for the Scheduled Instance to start. This value must be later than or
     *         equal to the earliest date and at most three months in the future.
     */
    public Instant latestTime() {
        return latestTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((earliestTime() == null) ? 0 : earliestTime().hashCode());
        hashCode = 31 * hashCode + ((latestTime() == null) ? 0 : latestTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotDateTimeRangeRequest)) {
            return false;
        }
        SlotDateTimeRangeRequest other = (SlotDateTimeRangeRequest) obj;
        if (other.earliestTime() == null ^ this.earliestTime() == null) {
            return false;
        }
        if (other.earliestTime() != null && !other.earliestTime().equals(this.earliestTime())) {
            return false;
        }
        if (other.latestTime() == null ^ this.latestTime() == null) {
            return false;
        }
        if (other.latestTime() != null && !other.latestTime().equals(this.latestTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (earliestTime() != null) {
            sb.append("EarliestTime: ").append(earliestTime()).append(",");
        }
        if (latestTime() != null) {
            sb.append("LatestTime: ").append(latestTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EarliestTime":
            return Optional.of(clazz.cast(earliestTime()));
        case "LatestTime":
            return Optional.of(clazz.cast(latestTime()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SlotDateTimeRangeRequest> {
        /**
         * <p>
         * The earliest date and time, in UTC, for the Scheduled Instance to start.
         * </p>
         * 
         * @param earliestTime
         *        The earliest date and time, in UTC, for the Scheduled Instance to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earliestTime(Instant earliestTime);

        /**
         * <p>
         * The latest date and time, in UTC, for the Scheduled Instance to start. This value must be later than or equal
         * to the earliest date and at most three months in the future.
         * </p>
         * 
         * @param latestTime
         *        The latest date and time, in UTC, for the Scheduled Instance to start. This value must be later than
         *        or equal to the earliest date and at most three months in the future.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestTime(Instant latestTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant earliestTime;

        private Instant latestTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotDateTimeRangeRequest model) {
            earliestTime(model.earliestTime);
            latestTime(model.latestTime);
        }

        public final Instant getEarliestTime() {
            return earliestTime;
        }

        @Override
        public final Builder earliestTime(Instant earliestTime) {
            this.earliestTime = earliestTime;
            return this;
        }

        public final void setEarliestTime(Instant earliestTime) {
            this.earliestTime = earliestTime;
        }

        public final Instant getLatestTime() {
            return latestTime;
        }

        @Override
        public final Builder latestTime(Instant latestTime) {
            this.latestTime = latestTime;
            return this;
        }

        public final void setLatestTime(Instant latestTime) {
            this.latestTime = latestTime;
        }

        @Override
        public SlotDateTimeRangeRequest build() {
            return new SlotDateTimeRangeRequest(this);
        }
    }
}
