/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Spot fleet request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SpotFleetRequestConfig implements ToCopyableBuilder<SpotFleetRequestConfig.Builder, SpotFleetRequestConfig> {
    private final String activityStatus;

    private final Instant createTime;

    private final SpotFleetRequestConfigData spotFleetRequestConfig;

    private final String spotFleetRequestId;

    private final String spotFleetRequestState;

    private SpotFleetRequestConfig(BuilderImpl builder) {
        this.activityStatus = builder.activityStatus;
        this.createTime = builder.createTime;
        this.spotFleetRequestConfig = builder.spotFleetRequestConfig;
        this.spotFleetRequestId = builder.spotFleetRequestId;
        this.spotFleetRequestState = builder.spotFleetRequestState;
    }

    /**
     * <p>
     * The progress of the Spot fleet request. If there is an error, the status is <code>error</code>. After all bids
     * are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or greater than
     * its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is decreased, the status is
     * <code>pending_termination</code> while Spot instances are terminating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activityStatus}
     * will return {@link ActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activityStatusString}.
     * </p>
     * 
     * @return The progress of the Spot fleet request. If there is an error, the status is <code>error</code>. After all
     *         bids are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or
     *         greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is
     *         decreased, the status is <code>pending_termination</code> while Spot instances are terminating.
     * @see ActivityStatus
     */
    public ActivityStatus activityStatus() {
        return ActivityStatus.fromValue(activityStatus);
    }

    /**
     * <p>
     * The progress of the Spot fleet request. If there is an error, the status is <code>error</code>. After all bids
     * are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or greater than
     * its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is decreased, the status is
     * <code>pending_termination</code> while Spot instances are terminating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activityStatus}
     * will return {@link ActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activityStatusString}.
     * </p>
     * 
     * @return The progress of the Spot fleet request. If there is an error, the status is <code>error</code>. After all
     *         bids are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or
     *         greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is
     *         decreased, the status is <code>pending_termination</code> while Spot instances are terminating.
     * @see ActivityStatus
     */
    public String activityStatusString() {
        return activityStatus;
    }

    /**
     * <p>
     * The creation date and time of the request.
     * </p>
     * 
     * @return The creation date and time of the request.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Information about the configuration of the Spot fleet request.
     * </p>
     * 
     * @return Information about the configuration of the Spot fleet request.
     */
    public SpotFleetRequestConfigData spotFleetRequestConfig() {
        return spotFleetRequestConfig;
    }

    /**
     * <p>
     * The ID of the Spot fleet request.
     * </p>
     * 
     * @return The ID of the Spot fleet request.
     */
    public String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    /**
     * <p>
     * The state of the Spot fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #spotFleetRequestStateString}.
     * </p>
     * 
     * @return The state of the Spot fleet request.
     * @see BatchState
     */
    public BatchState spotFleetRequestState() {
        return BatchState.fromValue(spotFleetRequestState);
    }

    /**
     * <p>
     * The state of the Spot fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #spotFleetRequestStateString}.
     * </p>
     * 
     * @return The state of the Spot fleet request.
     * @see BatchState
     */
    public String spotFleetRequestStateString() {
        return spotFleetRequestState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activityStatusString() == null) ? 0 : activityStatusString().hashCode());
        hashCode = 31 * hashCode + ((createTime() == null) ? 0 : createTime().hashCode());
        hashCode = 31 * hashCode + ((spotFleetRequestConfig() == null) ? 0 : spotFleetRequestConfig().hashCode());
        hashCode = 31 * hashCode + ((spotFleetRequestId() == null) ? 0 : spotFleetRequestId().hashCode());
        hashCode = 31 * hashCode + ((spotFleetRequestStateString() == null) ? 0 : spotFleetRequestStateString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfig)) {
            return false;
        }
        SpotFleetRequestConfig other = (SpotFleetRequestConfig) obj;
        if (other.activityStatusString() == null ^ this.activityStatusString() == null) {
            return false;
        }
        if (other.activityStatusString() != null && !other.activityStatusString().equals(this.activityStatusString())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.spotFleetRequestConfig() == null ^ this.spotFleetRequestConfig() == null) {
            return false;
        }
        if (other.spotFleetRequestConfig() != null && !other.spotFleetRequestConfig().equals(this.spotFleetRequestConfig())) {
            return false;
        }
        if (other.spotFleetRequestId() == null ^ this.spotFleetRequestId() == null) {
            return false;
        }
        if (other.spotFleetRequestId() != null && !other.spotFleetRequestId().equals(this.spotFleetRequestId())) {
            return false;
        }
        if (other.spotFleetRequestStateString() == null ^ this.spotFleetRequestStateString() == null) {
            return false;
        }
        if (other.spotFleetRequestStateString() != null
                && !other.spotFleetRequestStateString().equals(this.spotFleetRequestStateString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (activityStatusString() != null) {
            sb.append("ActivityStatus: ").append(activityStatusString()).append(",");
        }
        if (createTime() != null) {
            sb.append("CreateTime: ").append(createTime()).append(",");
        }
        if (spotFleetRequestConfig() != null) {
            sb.append("SpotFleetRequestConfig: ").append(spotFleetRequestConfig()).append(",");
        }
        if (spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(spotFleetRequestId()).append(",");
        }
        if (spotFleetRequestStateString() != null) {
            sb.append("SpotFleetRequestState: ").append(spotFleetRequestStateString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivityStatus":
            return Optional.of(clazz.cast(activityStatusString()));
        case "CreateTime":
            return Optional.of(clazz.cast(createTime()));
        case "SpotFleetRequestConfig":
            return Optional.of(clazz.cast(spotFleetRequestConfig()));
        case "SpotFleetRequestId":
            return Optional.of(clazz.cast(spotFleetRequestId()));
        case "SpotFleetRequestState":
            return Optional.of(clazz.cast(spotFleetRequestStateString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SpotFleetRequestConfig> {
        /**
         * <p>
         * The progress of the Spot fleet request. If there is an error, the status is <code>error</code>. After all
         * bids are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or
         * greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is
         * decreased, the status is <code>pending_termination</code> while Spot instances are terminating.
         * </p>
         * 
         * @param activityStatus
         *        The progress of the Spot fleet request. If there is an error, the status is <code>error</code>. After
         *        all bids are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal
         *        to or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet
         *        is decreased, the status is <code>pending_termination</code> while Spot instances are terminating.
         * @see ActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStatus
         */
        Builder activityStatus(String activityStatus);

        /**
         * <p>
         * The progress of the Spot fleet request. If there is an error, the status is <code>error</code>. After all
         * bids are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal to or
         * greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet is
         * decreased, the status is <code>pending_termination</code> while Spot instances are terminating.
         * </p>
         * 
         * @param activityStatus
         *        The progress of the Spot fleet request. If there is an error, the status is <code>error</code>. After
         *        all bids are placed, the status is <code>pending_fulfillment</code>. If the size of the fleet is equal
         *        to or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the fleet
         *        is decreased, the status is <code>pending_termination</code> while Spot instances are terminating.
         * @see ActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStatus
         */
        Builder activityStatus(ActivityStatus activityStatus);

        /**
         * <p>
         * The creation date and time of the request.
         * </p>
         * 
         * @param createTime
         *        The creation date and time of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Information about the configuration of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestConfig
         *        Information about the configuration of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig);

        /**
         * <p>
         * The ID of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);

        /**
         * <p>
         * The state of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestState
         *        The state of the Spot fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder spotFleetRequestState(String spotFleetRequestState);

        /**
         * <p>
         * The state of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestState
         *        The state of the Spot fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder spotFleetRequestState(BatchState spotFleetRequestState);
    }

    static final class BuilderImpl implements Builder {
        private String activityStatus;

        private Instant createTime;

        private SpotFleetRequestConfigData spotFleetRequestConfig;

        private String spotFleetRequestId;

        private String spotFleetRequestState;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfig model) {
            activityStatus(model.activityStatus);
            createTime(model.createTime);
            spotFleetRequestConfig(model.spotFleetRequestConfig);
            spotFleetRequestId(model.spotFleetRequestId);
            spotFleetRequestState(model.spotFleetRequestState);
        }

        public final String getActivityStatus() {
            return activityStatus;
        }

        @Override
        public final Builder activityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
            return this;
        }

        @Override
        public final Builder activityStatus(ActivityStatus activityStatus) {
            this.activityStatus(activityStatus.toString());
            return this;
        }

        public final void setActivityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final SpotFleetRequestConfigData.Builder getSpotFleetRequestConfig() {
            return spotFleetRequestConfig != null ? spotFleetRequestConfig.toBuilder() : null;
        }

        @Override
        public final Builder spotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig;
            return this;
        }

        public final void setSpotFleetRequestConfig(SpotFleetRequestConfigData.BuilderImpl spotFleetRequestConfig) {
            this.spotFleetRequestConfig = spotFleetRequestConfig != null ? spotFleetRequestConfig.build() : null;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public final String getSpotFleetRequestState() {
            return spotFleetRequestState;
        }

        @Override
        public final Builder spotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
            return this;
        }

        @Override
        public final Builder spotFleetRequestState(BatchState spotFleetRequestState) {
            this.spotFleetRequestState(spotFleetRequestState.toString());
            return this;
        }

        public final void setSpotFleetRequestState(String spotFleetRequestState) {
            this.spotFleetRequestState = spotFleetRequestState;
        }

        @Override
        public SpotFleetRequestConfig build() {
            return new SpotFleetRequestConfig(this);
        }
    }
}
