/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes Spot instance placement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SpotPlacement implements ToCopyableBuilder<SpotPlacement.Builder, SpotPlacement> {
    private final String availabilityZone;

    private final String groupName;

    private final String tenancy;

    private SpotPlacement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.groupName = builder.groupName;
        this.tenancy = builder.tenancy;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * <p>
     * [Spot fleet only] To specify multiple Availability Zones, separate them using commas; for example,
     * "us-west-2a, us-west-2b".
     * </p>
     * 
     * @return The Availability Zone.</p>
     *         <p>
     *         [Spot fleet only] To specify multiple Availability Zones, separate them using commas; for example,
     *         "us-west-2a, us-west-2b".
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The name of the placement group (for cluster instances).
     * </p>
     * 
     * @return The name of the placement group (for cluster instances).
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for Spot
     * instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyString}.
     * </p>
     * 
     * @return The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     *         <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
     *         Spot instances.
     * @see Tenancy
     */
    public Tenancy tenancy() {
        return Tenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for Spot
     * instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tenancyString}.
     * </p>
     * 
     * @return The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
     *         <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
     *         Spot instances.
     * @see Tenancy
     */
    public String tenancyString() {
        return tenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((groupName() == null) ? 0 : groupName().hashCode());
        hashCode = 31 * hashCode + ((tenancyString() == null) ? 0 : tenancyString().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotPlacement)) {
            return false;
        }
        SpotPlacement other = (SpotPlacement) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.tenancyString() == null ^ this.tenancyString() == null) {
            return false;
        }
        if (other.tenancyString() != null && !other.tenancyString().equals(this.tenancyString())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (groupName() != null) {
            sb.append("GroupName: ").append(groupName()).append(",");
        }
        if (tenancyString() != null) {
            sb.append("Tenancy: ").append(tenancyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "GroupName":
            return Optional.of(clazz.cast(groupName()));
        case "Tenancy":
            return Optional.of(clazz.cast(tenancyString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SpotPlacement> {
        /**
         * <p>
         * The Availability Zone.
         * </p>
         * <p>
         * [Spot fleet only] To specify multiple Availability Zones, separate them using commas; for example,
         * "us-west-2a, us-west-2b".
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.</p>
         *        <p>
         *        [Spot fleet only] To specify multiple Availability Zones, separate them using commas; for example,
         *        "us-west-2a, us-west-2b".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The name of the placement group (for cluster instances).
         * </p>
         * 
         * @param groupName
         *        The name of the placement group (for cluster instances).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
         * Spot instances.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         *        <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported
         *        for Spot instances.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         * <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported for
         * Spot instances.
         * </p>
         * 
         * @param tenancy
         *        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of
         *        <code>dedicated</code> runs on single-tenant hardware. The <code>host</code> tenancy is not supported
         *        for Spot instances.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder tenancy(Tenancy tenancy);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String groupName;

        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotPlacement model) {
            availabilityZone(model.availabilityZone);
            groupName(model.groupName);
            tenancy(model.tenancy);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getTenancy() {
            return tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public SpotPlacement build() {
            return new SpotPlacement(this);
        }
    }
}
