/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a stale rule in a security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StaleIpPermission implements ToCopyableBuilder<StaleIpPermission.Builder, StaleIpPermission> {
    private final Integer fromPort;

    private final String ipProtocol;

    private final List<String> ipRanges;

    private final List<String> prefixListIds;

    private final Integer toPort;

    private final List<UserIdGroupPair> userIdGroupPairs;

    private StaleIpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.ipRanges = builder.ipRanges;
        this.prefixListIds = builder.prefixListIds;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
    }

    /**
     * <p>
     * The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of <code>-1</code>
     * indicates all ICMP types.
     * </p>
     * 
     * @return The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
     *         <code>-1</code> indicates all ICMP types.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The IP protocol name (for <code>tcp</code>, <code>udp</code>, and <code>icmp</code>) or number (see <a
     * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers)</a>.
     * </p>
     * 
     * @return The IP protocol name (for <code>tcp</code>, <code>udp</code>, and <code>icmp</code>) or number (see <a
     *         href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers)</a>.
     */
    public String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * One or more IP ranges. Not applicable for stale security group rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more IP ranges. Not applicable for stale security group rules.
     */
    public List<String> ipRanges() {
        return ipRanges;
    }

    /**
     * <p>
     * One or more prefix list IDs for an AWS service. Not applicable for stale security group rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more prefix list IDs for an AWS service. Not applicable for stale security group rules.
     */
    public List<String> prefixListIds() {
        return prefixListIds;
    }

    /**
     * <p>
     * The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of <code>-1</code>
     * indicates all ICMP types.
     * </p>
     * 
     * @return The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
     *         <code>-1</code> indicates all ICMP types.
     */
    public Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * One or more security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status
     * of the VPC peering connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group pairs. Returns the ID of the referenced security group and VPC, and the ID and
     *         status of the VPC peering connection.
     */
    public List<UserIdGroupPair> userIdGroupPairs() {
        return userIdGroupPairs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fromPort() == null) ? 0 : fromPort().hashCode());
        hashCode = 31 * hashCode + ((ipProtocol() == null) ? 0 : ipProtocol().hashCode());
        hashCode = 31 * hashCode + ((ipRanges() == null) ? 0 : ipRanges().hashCode());
        hashCode = 31 * hashCode + ((prefixListIds() == null) ? 0 : prefixListIds().hashCode());
        hashCode = 31 * hashCode + ((toPort() == null) ? 0 : toPort().hashCode());
        hashCode = 31 * hashCode + ((userIdGroupPairs() == null) ? 0 : userIdGroupPairs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaleIpPermission)) {
            return false;
        }
        StaleIpPermission other = (StaleIpPermission) obj;
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.ipProtocol() == null ^ this.ipProtocol() == null) {
            return false;
        }
        if (other.ipProtocol() != null && !other.ipProtocol().equals(this.ipProtocol())) {
            return false;
        }
        if (other.ipRanges() == null ^ this.ipRanges() == null) {
            return false;
        }
        if (other.ipRanges() != null && !other.ipRanges().equals(this.ipRanges())) {
            return false;
        }
        if (other.prefixListIds() == null ^ this.prefixListIds() == null) {
            return false;
        }
        if (other.prefixListIds() != null && !other.prefixListIds().equals(this.prefixListIds())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        if (other.toPort() != null && !other.toPort().equals(this.toPort())) {
            return false;
        }
        if (other.userIdGroupPairs() == null ^ this.userIdGroupPairs() == null) {
            return false;
        }
        if (other.userIdGroupPairs() != null && !other.userIdGroupPairs().equals(this.userIdGroupPairs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fromPort() != null) {
            sb.append("FromPort: ").append(fromPort()).append(",");
        }
        if (ipProtocol() != null) {
            sb.append("IpProtocol: ").append(ipProtocol()).append(",");
        }
        if (ipRanges() != null) {
            sb.append("IpRanges: ").append(ipRanges()).append(",");
        }
        if (prefixListIds() != null) {
            sb.append("PrefixListIds: ").append(prefixListIds()).append(",");
        }
        if (toPort() != null) {
            sb.append("ToPort: ").append(toPort()).append(",");
        }
        if (userIdGroupPairs() != null) {
            sb.append("UserIdGroupPairs: ").append(userIdGroupPairs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromPort":
            return Optional.of(clazz.cast(fromPort()));
        case "IpProtocol":
            return Optional.of(clazz.cast(ipProtocol()));
        case "IpRanges":
            return Optional.of(clazz.cast(ipRanges()));
        case "PrefixListIds":
            return Optional.of(clazz.cast(prefixListIds()));
        case "ToPort":
            return Optional.of(clazz.cast(toPort()));
        case "UserIdGroupPairs":
            return Optional.of(clazz.cast(userIdGroupPairs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StaleIpPermission> {
        /**
         * <p>
         * The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of <code>-1</code>
         * indicates all ICMP types.
         * </p>
         * 
         * @param fromPort
         *        The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
         *        <code>-1</code> indicates all ICMP types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The IP protocol name (for <code>tcp</code>, <code>udp</code>, and <code>icmp</code>) or number (see <a
         * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers)</a>.
         * </p>
         * 
         * @param ipProtocol
         *        The IP protocol name (for <code>tcp</code>, <code>udp</code>, and <code>icmp</code>) or number (see <a
         *        href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * One or more IP ranges. Not applicable for stale security group rules.
         * </p>
         * 
         * @param ipRanges
         *        One or more IP ranges. Not applicable for stale security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(Collection<String> ipRanges);

        /**
         * <p>
         * One or more IP ranges. Not applicable for stale security group rules.
         * </p>
         * 
         * @param ipRanges
         *        One or more IP ranges. Not applicable for stale security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(String... ipRanges);

        /**
         * <p>
         * One or more prefix list IDs for an AWS service. Not applicable for stale security group rules.
         * </p>
         * 
         * @param prefixListIds
         *        One or more prefix list IDs for an AWS service. Not applicable for stale security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(Collection<String> prefixListIds);

        /**
         * <p>
         * One or more prefix list IDs for an AWS service. Not applicable for stale security group rules.
         * </p>
         * 
         * @param prefixListIds
         *        One or more prefix list IDs for an AWS service. Not applicable for stale security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(String... prefixListIds);

        /**
         * <p>
         * The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of <code>-1</code>
         * indicates all ICMP types.
         * </p>
         * 
         * @param toPort
         *        The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
         *        <code>-1</code> indicates all ICMP types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * One or more security group pairs. Returns the ID of the referenced security group and VPC, and the ID and
         * status of the VPC peering connection.
         * </p>
         * 
         * @param userIdGroupPairs
         *        One or more security group pairs. Returns the ID of the referenced security group and VPC, and the ID
         *        and status of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs);

        /**
         * <p>
         * One or more security group pairs. Returns the ID of the referenced security group and VPC, and the ID and
         * status of the VPC peering connection.
         * </p>
         * 
         * @param userIdGroupPairs
         *        One or more security group pairs. Returns the ID of the referenced security group and VPC, and the ID
         *        and status of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(UserIdGroupPair... userIdGroupPairs);
    }

    static final class BuilderImpl implements Builder {
        private Integer fromPort;

        private String ipProtocol;

        private List<String> ipRanges;

        private List<String> prefixListIds;

        private Integer toPort;

        private List<UserIdGroupPair> userIdGroupPairs;

        private BuilderImpl() {
        }

        private BuilderImpl(StaleIpPermission model) {
            fromPort(model.fromPort);
            ipProtocol(model.ipProtocol);
            ipRanges(model.ipRanges);
            prefixListIds(model.prefixListIds);
            toPort(model.toPort);
            userIdGroupPairs(model.userIdGroupPairs);
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Collection<String> getIpRanges() {
            return ipRanges;
        }

        @Override
        public final Builder ipRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangesCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(String... ipRanges) {
            ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        public final void setIpRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangesCopier.copy(ipRanges);
        }

        public final Collection<String> getPrefixListIds() {
            return prefixListIds;
        }

        @Override
        public final Builder prefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = PrefixListIdSetCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(String... prefixListIds) {
            prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        public final void setPrefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = PrefixListIdSetCopier.copy(prefixListIds);
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final Collection<UserIdGroupPair.Builder> getUserIdGroupPairs() {
            return userIdGroupPairs != null ? userIdGroupPairs.stream().map(UserIdGroupPair::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairSetCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(UserIdGroupPair... userIdGroupPairs) {
            userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        public final void setUserIdGroupPairs(Collection<UserIdGroupPair.BuilderImpl> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairSetCopier.copyFromBuilder(userIdGroupPairs);
        }

        @Override
        public StaleIpPermission build() {
            return new StaleIpPermission(this);
        }
    }
}
