/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes volume attachment details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeAttachment implements ToCopyableBuilder<VolumeAttachment.Builder, VolumeAttachment> {
    private final Instant attachTime;

    private final String device;

    private final String instanceId;

    private final String state;

    private final String volumeId;

    private final Boolean deleteOnTermination;

    private VolumeAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.device = builder.device;
        this.instanceId = builder.instanceId;
        this.state = builder.state;
        this.volumeId = builder.volumeId;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    /**
     * <p>
     * The time stamp when the attachment initiated.
     * </p>
     * 
     * @return The time stamp when the attachment initiated.
     */
    public Instant attachTime() {
        return attachTime;
    }

    /**
     * <p>
     * The device name.
     * </p>
     * 
     * @return The device name.
     */
    public String device() {
        return device;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The attachment state of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VolumeAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The attachment state of the volume.
     * @see VolumeAttachmentState
     */
    public VolumeAttachmentState state() {
        return VolumeAttachmentState.fromValue(state);
    }

    /**
     * <p>
     * The attachment state of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VolumeAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The attachment state of the volume.
     * @see VolumeAttachmentState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * Indicates whether the EBS volume is deleted on instance termination.
     * </p>
     * 
     * @return Indicates whether the EBS volume is deleted on instance termination.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attachTime() == null) ? 0 : attachTime().hashCode());
        hashCode = 31 * hashCode + ((device() == null) ? 0 : device().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((stateString() == null) ? 0 : stateString().hashCode());
        hashCode = 31 * hashCode + ((volumeId() == null) ? 0 : volumeId().hashCode());
        hashCode = 31 * hashCode + ((deleteOnTermination() == null) ? 0 : deleteOnTermination().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeAttachment)) {
            return false;
        }
        VolumeAttachment other = (VolumeAttachment) obj;
        if (other.attachTime() == null ^ this.attachTime() == null) {
            return false;
        }
        if (other.attachTime() != null && !other.attachTime().equals(this.attachTime())) {
            return false;
        }
        if (other.device() == null ^ this.device() == null) {
            return false;
        }
        if (other.device() != null && !other.device().equals(this.device())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        if (other.deleteOnTermination() == null ^ this.deleteOnTermination() == null) {
            return false;
        }
        if (other.deleteOnTermination() != null && !other.deleteOnTermination().equals(this.deleteOnTermination())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attachTime() != null) {
            sb.append("AttachTime: ").append(attachTime()).append(",");
        }
        if (device() != null) {
            sb.append("Device: ").append(device()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (volumeId() != null) {
            sb.append("VolumeId: ").append(volumeId()).append(",");
        }
        if (deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(deleteOnTermination()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachTime":
            return Optional.of(clazz.cast(attachTime()));
        case "Device":
            return Optional.of(clazz.cast(device()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "VolumeId":
            return Optional.of(clazz.cast(volumeId()));
        case "DeleteOnTermination":
            return Optional.of(clazz.cast(deleteOnTermination()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeAttachment> {
        /**
         * <p>
         * The time stamp when the attachment initiated.
         * </p>
         * 
         * @param attachTime
         *        The time stamp when the attachment initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachTime(Instant attachTime);

        /**
         * <p>
         * The device name.
         * </p>
         * 
         * @param device
         *        The device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The attachment state of the volume.
         * </p>
         * 
         * @param state
         *        The attachment state of the volume.
         * @see VolumeAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeAttachmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The attachment state of the volume.
         * </p>
         * 
         * @param state
         *        The attachment state of the volume.
         * @see VolumeAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeAttachmentState
         */
        Builder state(VolumeAttachmentState state);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * Indicates whether the EBS volume is deleted on instance termination.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the EBS volume is deleted on instance termination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);
    }

    static final class BuilderImpl implements Builder {
        private Instant attachTime;

        private String device;

        private String instanceId;

        private String state;

        private String volumeId;

        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeAttachment model) {
            attachTime(model.attachTime);
            device(model.device);
            instanceId(model.instanceId);
            state(model.state);
            volumeId(model.volumeId);
            deleteOnTermination(model.deleteOnTermination);
        }

        public final Instant getAttachTime() {
            return attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        public final String getDevice() {
            return device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeAttachmentState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public VolumeAttachment build() {
            return new VolumeAttachment(this);
        }
    }
}
