/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeFlowLogsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeFlowLogsRequestMarshaller implements Marshaller<Request<DescribeFlowLogsRequest>, DescribeFlowLogsRequest> {

    public Request<DescribeFlowLogsRequest> marshall(DescribeFlowLogsRequest describeFlowLogsRequest) {

        if (describeFlowLogsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeFlowLogsRequest> request = new DefaultRequest<DescribeFlowLogsRequest>(describeFlowLogsRequest,
                "EC2Client");
        request.addParameter("Action", "DescribeFlowLogs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeFlowLogsRequestFilterList = describeFlowLogsRequest.filter();
        if (describeFlowLogsRequestFilterList != null) {
            int filterListIndex = 1;

            for (Filter describeFlowLogsRequestFilterListValue : describeFlowLogsRequestFilterList) {

                if (describeFlowLogsRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name",
                            StringUtils.fromString(describeFlowLogsRequestFilterListValue.name()));
                }

                java.util.List<String> filterValuesList = describeFlowLogsRequestFilterListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filterListIndex++;
            }
        }

        java.util.List<String> describeFlowLogsRequestFlowLogIdsList = describeFlowLogsRequest.flowLogIds();
        if (describeFlowLogsRequestFlowLogIdsList != null) {
            int flowLogIdsListIndex = 1;

            for (String describeFlowLogsRequestFlowLogIdsListValue : describeFlowLogsRequestFlowLogIdsList) {
                if (describeFlowLogsRequestFlowLogIdsListValue != null) {
                    request.addParameter("FlowLogId." + flowLogIdsListIndex,
                            StringUtils.fromString(describeFlowLogsRequestFlowLogIdsListValue));
                }
                flowLogIdsListIndex++;
            }
        }

        if (describeFlowLogsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeFlowLogsRequest.maxResults()));
        }

        if (describeFlowLogsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeFlowLogsRequest.nextToken()));
        }

        return request;
    }

}
