/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeScheduledInstanceAvailabilityRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeScheduledInstanceAvailabilityRequestMarshaller implements
        Marshaller<Request<DescribeScheduledInstanceAvailabilityRequest>, DescribeScheduledInstanceAvailabilityRequest> {

    public Request<DescribeScheduledInstanceAvailabilityRequest> marshall(
            DescribeScheduledInstanceAvailabilityRequest describeScheduledInstanceAvailabilityRequest) {

        if (describeScheduledInstanceAvailabilityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeScheduledInstanceAvailabilityRequest> request = new DefaultRequest<DescribeScheduledInstanceAvailabilityRequest>(
                describeScheduledInstanceAvailabilityRequest, "EC2Client");
        request.addParameter("Action", "DescribeScheduledInstanceAvailability");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeScheduledInstanceAvailabilityRequestFiltersList = describeScheduledInstanceAvailabilityRequest
                .filters();
        if (describeScheduledInstanceAvailabilityRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeScheduledInstanceAvailabilityRequestFiltersListValue : describeScheduledInstanceAvailabilityRequestFiltersList) {

                if (describeScheduledInstanceAvailabilityRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeScheduledInstanceAvailabilityRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeScheduledInstanceAvailabilityRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        SlotDateTimeRangeRequest firstSlotStartTimeRange = describeScheduledInstanceAvailabilityRequest.firstSlotStartTimeRange();
        if (firstSlotStartTimeRange != null) {

            if (firstSlotStartTimeRange.earliestTime() != null) {
                request.addParameter("FirstSlotStartTimeRange.EarliestTime",
                        StringUtils.fromInstant(firstSlotStartTimeRange.earliestTime()));
            }

            if (firstSlotStartTimeRange.latestTime() != null) {
                request.addParameter("FirstSlotStartTimeRange.LatestTime",
                        StringUtils.fromInstant(firstSlotStartTimeRange.latestTime()));
            }
        }

        if (describeScheduledInstanceAvailabilityRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeScheduledInstanceAvailabilityRequest.maxResults()));
        }

        if (describeScheduledInstanceAvailabilityRequest.maxSlotDurationInHours() != null) {
            request.addParameter("MaxSlotDurationInHours",
                    StringUtils.fromInteger(describeScheduledInstanceAvailabilityRequest.maxSlotDurationInHours()));
        }

        if (describeScheduledInstanceAvailabilityRequest.minSlotDurationInHours() != null) {
            request.addParameter("MinSlotDurationInHours",
                    StringUtils.fromInteger(describeScheduledInstanceAvailabilityRequest.minSlotDurationInHours()));
        }

        if (describeScheduledInstanceAvailabilityRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeScheduledInstanceAvailabilityRequest.nextToken()));
        }

        ScheduledInstanceRecurrenceRequest recurrence = describeScheduledInstanceAvailabilityRequest.recurrence();
        if (recurrence != null) {

            if (recurrence.frequency() != null) {
                request.addParameter("Recurrence.Frequency", StringUtils.fromString(recurrence.frequency()));
            }

            if (recurrence.interval() != null) {
                request.addParameter("Recurrence.Interval", StringUtils.fromInteger(recurrence.interval()));
            }

            java.util.List<Integer> scheduledInstanceRecurrenceRequestOccurrenceDaysList = recurrence.occurrenceDays();
            if (scheduledInstanceRecurrenceRequestOccurrenceDaysList != null) {
                int occurrenceDaysListIndex = 1;

                for (Integer scheduledInstanceRecurrenceRequestOccurrenceDaysListValue : scheduledInstanceRecurrenceRequestOccurrenceDaysList) {
                    if (scheduledInstanceRecurrenceRequestOccurrenceDaysListValue != null) {
                        request.addParameter("Recurrence.OccurrenceDay." + occurrenceDaysListIndex,
                                StringUtils.fromInteger(scheduledInstanceRecurrenceRequestOccurrenceDaysListValue));
                    }
                    occurrenceDaysListIndex++;
                }
            }

            if (recurrence.occurrenceRelativeToEnd() != null) {
                request.addParameter("Recurrence.OccurrenceRelativeToEnd",
                        StringUtils.fromBoolean(recurrence.occurrenceRelativeToEnd()));
            }

            if (recurrence.occurrenceUnit() != null) {
                request.addParameter("Recurrence.OccurrenceUnit", StringUtils.fromString(recurrence.occurrenceUnit()));
            }
        }

        return request;
    }

}
