/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * FpgaImage StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class FpgaImageUnmarshaller implements Unmarshaller<FpgaImage, StaxUnmarshallerContext> {

    public FpgaImage unmarshall(StaxUnmarshallerContext context) throws Exception {
        FpgaImage.Builder fpgaImage = FpgaImage.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ProductCode> productCodes = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                fpgaImage.productCodes(productCodes);
                fpgaImage.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("fpgaImageId", targetDepth)) {
                    fpgaImage.fpgaImageId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("fpgaImageGlobalId", targetDepth)) {
                    fpgaImage.fpgaImageGlobalId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("name", targetDepth)) {
                    fpgaImage.name(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("description", targetDepth)) {
                    fpgaImage.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("shellVersion", targetDepth)) {
                    fpgaImage.shellVersion(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("pciId", targetDepth)) {
                    fpgaImage.pciId(PciIdUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("state", targetDepth)) {
                    fpgaImage.state(FpgaImageStateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("createTime", targetDepth)) {
                    fpgaImage.createTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("updateTime", targetDepth)) {
                    fpgaImage.updateTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ownerId", targetDepth)) {
                    fpgaImage.ownerId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ownerAlias", targetDepth)) {
                    fpgaImage.ownerAlias(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("productCodes", targetDepth)) {
                    productCodes = new ArrayList<ProductCode>();
                    continue;
                }

                if (context.testExpression("productCodes/item", targetDepth)) {
                    productCodes.add(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tags", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tags/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    fpgaImage.productCodes(productCodes);
                    fpgaImage.tags(tags);
                    break;
                }
            }
        }
        return fpgaImage.build();
    }

    private static final FpgaImageUnmarshaller INSTANCE = new FpgaImageUnmarshaller();

    public static FpgaImageUnmarshaller getInstance() {
        return INSTANCE;
    }
}
