/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * InstanceNetworkInterface StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstanceNetworkInterfaceUnmarshaller implements Unmarshaller<InstanceNetworkInterface, StaxUnmarshallerContext> {

    public InstanceNetworkInterface unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceNetworkInterface.Builder instanceNetworkInterface = InstanceNetworkInterface.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<GroupIdentifier> groups = null;
        java.util.List<InstanceIpv6Address> ipv6Addresses = null;
        java.util.List<InstancePrivateIpAddress> privateIpAddresses = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                instanceNetworkInterface.groups(groups);
                instanceNetworkInterface.ipv6Addresses(ipv6Addresses);
                instanceNetworkInterface.privateIpAddresses(privateIpAddresses);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("association", targetDepth)) {
                    instanceNetworkInterface.association(InstanceNetworkInterfaceAssociationUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("attachment", targetDepth)) {
                    instanceNetworkInterface.attachment(InstanceNetworkInterfaceAttachmentUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("description", targetDepth)) {
                    instanceNetworkInterface.description(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groupSet", targetDepth)) {
                    groups = new ArrayList<GroupIdentifier>();
                    continue;
                }

                if (context.testExpression("groupSet/item", targetDepth)) {
                    groups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipv6AddressesSet", targetDepth)) {
                    ipv6Addresses = new ArrayList<InstanceIpv6Address>();
                    continue;
                }

                if (context.testExpression("ipv6AddressesSet/item", targetDepth)) {
                    ipv6Addresses.add(InstanceIpv6AddressUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("macAddress", targetDepth)) {
                    instanceNetworkInterface.macAddress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkInterfaceId", targetDepth)) {
                    instanceNetworkInterface.networkInterfaceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ownerId", targetDepth)) {
                    instanceNetworkInterface.ownerId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateDnsName", targetDepth)) {
                    instanceNetworkInterface.privateDnsName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateIpAddress", targetDepth)) {
                    instanceNetworkInterface.privateIpAddress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateIpAddressesSet", targetDepth)) {
                    privateIpAddresses = new ArrayList<InstancePrivateIpAddress>();
                    continue;
                }

                if (context.testExpression("privateIpAddressesSet/item", targetDepth)) {
                    privateIpAddresses.add(InstancePrivateIpAddressUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("sourceDestCheck", targetDepth)) {
                    instanceNetworkInterface.sourceDestCheck(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("status", targetDepth)) {
                    instanceNetworkInterface.status(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("subnetId", targetDepth)) {
                    instanceNetworkInterface.subnetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcId", targetDepth)) {
                    instanceNetworkInterface.vpcId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    instanceNetworkInterface.groups(groups);
                    instanceNetworkInterface.ipv6Addresses(ipv6Addresses);
                    instanceNetworkInterface.privateIpAddresses(privateIpAddresses);
                    break;
                }
            }
        }
        return instanceNetworkInterface.build();
    }

    private static final InstanceNetworkInterfaceUnmarshaller INSTANCE = new InstanceNetworkInterfaceUnmarshaller();

    public static InstanceNetworkInterfaceUnmarshaller getInstance() {
        return INSTANCE;
    }
}
