/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * RequestSpotFleetRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RequestSpotFleetRequestMarshaller implements Marshaller<Request<RequestSpotFleetRequest>, RequestSpotFleetRequest> {

    public Request<RequestSpotFleetRequest> marshall(RequestSpotFleetRequest requestSpotFleetRequest) {

        if (requestSpotFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<RequestSpotFleetRequest> request = new DefaultRequest<RequestSpotFleetRequest>(requestSpotFleetRequest,
                "EC2Client");
        request.addParameter("Action", "RequestSpotFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        SpotFleetRequestConfigData spotFleetRequestConfig = requestSpotFleetRequest.spotFleetRequestConfig();
        if (spotFleetRequestConfig != null) {

            if (spotFleetRequestConfig.allocationStrategyString() != null) {
                request.addParameter("SpotFleetRequestConfig.AllocationStrategy",
                        StringUtils.fromString(spotFleetRequestConfig.allocationStrategyString()));
            }

            if (spotFleetRequestConfig.clientToken() != null) {
                request.addParameter("SpotFleetRequestConfig.ClientToken",
                        StringUtils.fromString(spotFleetRequestConfig.clientToken()));
            }

            if (spotFleetRequestConfig.excessCapacityTerminationPolicyString() != null) {
                request.addParameter("SpotFleetRequestConfig.ExcessCapacityTerminationPolicy",
                        StringUtils.fromString(spotFleetRequestConfig.excessCapacityTerminationPolicyString()));
            }

            if (spotFleetRequestConfig.fulfilledCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.FulfilledCapacity",
                        StringUtils.fromDouble(spotFleetRequestConfig.fulfilledCapacity()));
            }

            if (spotFleetRequestConfig.iamFleetRole() != null) {
                request.addParameter("SpotFleetRequestConfig.IamFleetRole",
                        StringUtils.fromString(spotFleetRequestConfig.iamFleetRole()));
            }

            java.util.List<SpotFleetLaunchSpecification> spotFleetRequestConfigDataLaunchSpecificationsList = spotFleetRequestConfig
                    .launchSpecifications();
            if (spotFleetRequestConfigDataLaunchSpecificationsList != null) {
                int launchSpecificationsListIndex = 1;

                for (SpotFleetLaunchSpecification spotFleetRequestConfigDataLaunchSpecificationsListValue : spotFleetRequestConfigDataLaunchSpecificationsList) {

                    java.util.List<GroupIdentifier> spotFleetLaunchSpecificationSecurityGroupsList = spotFleetRequestConfigDataLaunchSpecificationsListValue
                            .securityGroups();
                    if (spotFleetLaunchSpecificationSecurityGroupsList != null) {
                        int securityGroupsListIndex = 1;

                        for (GroupIdentifier spotFleetLaunchSpecificationSecurityGroupsListValue : spotFleetLaunchSpecificationSecurityGroupsList) {

                            if (spotFleetLaunchSpecificationSecurityGroupsListValue.groupName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupName",
                                        StringUtils.fromString(spotFleetLaunchSpecificationSecurityGroupsListValue.groupName()));
                            }

                            if (spotFleetLaunchSpecificationSecurityGroupsListValue.groupId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupId",
                                        StringUtils.fromString(spotFleetLaunchSpecificationSecurityGroupsListValue.groupId()));
                            }
                            securityGroupsListIndex++;
                        }
                    }

                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.addressingType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                + ".AddressingType",
                                StringUtils.fromString(spotFleetRequestConfigDataLaunchSpecificationsListValue.addressingType()));
                    }

                    java.util.List<BlockDeviceMapping> spotFleetLaunchSpecificationBlockDeviceMappingsList = spotFleetRequestConfigDataLaunchSpecificationsListValue
                            .blockDeviceMappings();
                    if (spotFleetLaunchSpecificationBlockDeviceMappingsList != null) {
                        int blockDeviceMappingsListIndex = 1;

                        for (BlockDeviceMapping spotFleetLaunchSpecificationBlockDeviceMappingsListValue : spotFleetLaunchSpecificationBlockDeviceMappingsList) {

                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.deviceName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex
                                        + ".DeviceName", StringUtils
                                        .fromString(spotFleetLaunchSpecificationBlockDeviceMappingsListValue.deviceName()));
                            }

                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.virtualName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex
                                        + ".VirtualName", StringUtils
                                        .fromString(spotFleetLaunchSpecificationBlockDeviceMappingsListValue.virtualName()));
                            }

                            EbsBlockDevice ebs = spotFleetLaunchSpecificationBlockDeviceMappingsListValue.ebs();
                            if (ebs != null) {

                                if (ebs.encrypted() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                            + launchSpecificationsListIndex + ".BlockDeviceMapping."
                                            + blockDeviceMappingsListIndex + ".Ebs.Encrypted",
                                            StringUtils.fromBoolean(ebs.encrypted()));
                                }

                                if (ebs.deleteOnTermination() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                            + launchSpecificationsListIndex + ".BlockDeviceMapping."
                                            + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination",
                                            StringUtils.fromBoolean(ebs.deleteOnTermination()));
                                }

                                if (ebs.iops() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                            + launchSpecificationsListIndex + ".BlockDeviceMapping."
                                            + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger(ebs.iops()));
                                }

                                if (ebs.snapshotId() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                            + launchSpecificationsListIndex + ".BlockDeviceMapping."
                                            + blockDeviceMappingsListIndex + ".Ebs.SnapshotId",
                                            StringUtils.fromString(ebs.snapshotId()));
                                }

                                if (ebs.volumeSize() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                            + launchSpecificationsListIndex + ".BlockDeviceMapping."
                                            + blockDeviceMappingsListIndex + ".Ebs.VolumeSize",
                                            StringUtils.fromInteger(ebs.volumeSize()));
                                }

                                if (ebs.volumeTypeString() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                            + launchSpecificationsListIndex + ".BlockDeviceMapping."
                                            + blockDeviceMappingsListIndex + ".Ebs.VolumeType",
                                            StringUtils.fromString(ebs.volumeTypeString()));
                                }
                            }

                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.noDevice() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex
                                        + ".NoDevice", StringUtils
                                        .fromString(spotFleetLaunchSpecificationBlockDeviceMappingsListValue.noDevice()));
                            }
                            blockDeviceMappingsListIndex++;
                        }
                    }

                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.ebsOptimized() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                + ".EbsOptimized",
                                StringUtils.fromBoolean(spotFleetRequestConfigDataLaunchSpecificationsListValue.ebsOptimized()));
                    }

                    IamInstanceProfileSpecification iamInstanceProfile = spotFleetRequestConfigDataLaunchSpecificationsListValue
                            .iamInstanceProfile();
                    if (iamInstanceProfile != null) {

                        if (iamInstanceProfile.arn() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                    + ".IamInstanceProfile.Arn", StringUtils.fromString(iamInstanceProfile.arn()));
                        }

                        if (iamInstanceProfile.name() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                    + ".IamInstanceProfile.Name", StringUtils.fromString(iamInstanceProfile.name()));
                        }
                    }

                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.imageId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                + ".ImageId",
                                StringUtils.fromString(spotFleetRequestConfigDataLaunchSpecificationsListValue.imageId()));
                    }

                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.instanceTypeString() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                + ".InstanceType", StringUtils.fromString(spotFleetRequestConfigDataLaunchSpecificationsListValue
                                .instanceTypeString()));
                    }

                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.kernelId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                + ".KernelId",
                                StringUtils.fromString(spotFleetRequestConfigDataLaunchSpecificationsListValue.kernelId()));
                    }

                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.keyName() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                + ".KeyName",
                                StringUtils.fromString(spotFleetRequestConfigDataLaunchSpecificationsListValue.keyName()));
                    }

                    SpotFleetMonitoring monitoring = spotFleetRequestConfigDataLaunchSpecificationsListValue.monitoring();
                    if (monitoring != null) {

                        if (monitoring.enabled() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                    + ".Monitoring.Enabled", StringUtils.fromBoolean(monitoring.enabled()));
                        }
                    }

                    java.util.List<InstanceNetworkInterfaceSpecification> spotFleetLaunchSpecificationNetworkInterfacesList = spotFleetRequestConfigDataLaunchSpecificationsListValue
                            .networkInterfaces();
                    if (spotFleetLaunchSpecificationNetworkInterfacesList != null) {
                        int networkInterfacesListIndex = 1;

                        for (InstanceNetworkInterfaceSpecification spotFleetLaunchSpecificationNetworkInterfacesListValue : spotFleetLaunchSpecificationNetworkInterfacesList) {

                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex
                                        + ".AssociatePublicIpAddress", StringUtils
                                        .fromBoolean(spotFleetLaunchSpecificationNetworkInterfacesListValue
                                                .associatePublicIpAddress()));
                            }

                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.deleteOnTermination() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex
                                        + ".DeleteOnTermination",
                                        StringUtils.fromBoolean(spotFleetLaunchSpecificationNetworkInterfacesListValue
                                                .deleteOnTermination()));
                            }

                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.description() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex
                                        + ".Description", StringUtils
                                        .fromString(spotFleetLaunchSpecificationNetworkInterfacesListValue.description()));
                            }

                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.deviceIndex() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex
                                        + ".DeviceIndex", StringUtils
                                        .fromInteger(spotFleetLaunchSpecificationNetworkInterfacesListValue.deviceIndex()));
                            }

                            java.util.List<String> instanceNetworkInterfaceSpecificationGroupsList = spotFleetLaunchSpecificationNetworkInterfacesListValue
                                    .groups();
                            if (instanceNetworkInterfaceSpecificationGroupsList != null) {
                                int groupsListIndex = 1;

                                for (String instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                                    if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                                + launchSpecificationsListIndex + ".NetworkInterfaceSet."
                                                + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex,
                                                StringUtils.fromString(instanceNetworkInterfaceSpecificationGroupsListValue));
                                    }
                                    groupsListIndex++;
                                }
                            }

                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex
                                        + ".Ipv6AddressCount", StringUtils
                                        .fromInteger(spotFleetLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount()));
                            }

                            java.util.List<InstanceIpv6Address> instanceNetworkInterfaceSpecificationIpv6AddressesList = spotFleetLaunchSpecificationNetworkInterfacesListValue
                                    .ipv6Addresses();
                            if (instanceNetworkInterfaceSpecificationIpv6AddressesList != null) {
                                int ipv6AddressesListIndex = 1;

                                for (InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue : instanceNetworkInterfaceSpecificationIpv6AddressesList) {

                                    if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                                + launchSpecificationsListIndex + ".NetworkInterfaceSet."
                                                + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex
                                                + ".Ipv6Address", StringUtils
                                                .fromString(instanceNetworkInterfaceSpecificationIpv6AddressesListValue
                                                        .ipv6Address()));
                                    }
                                    ipv6AddressesListIndex++;
                                }
                            }

                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex
                                        + ".NetworkInterfaceId", StringUtils
                                        .fromString(spotFleetLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId()));
                            }

                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.privateIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex
                                        + ".PrivateIpAddress", StringUtils
                                        .fromString(spotFleetLaunchSpecificationNetworkInterfacesListValue.privateIpAddress()));
                            }

                            java.util.List<PrivateIpAddressSpecification> instanceNetworkInterfaceSpecificationPrivateIpAddressesList = spotFleetLaunchSpecificationNetworkInterfacesListValue
                                    .privateIpAddresses();
                            if (instanceNetworkInterfaceSpecificationPrivateIpAddressesList != null) {
                                int privateIpAddressesListIndex = 1;

                                for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {

                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                                + launchSpecificationsListIndex + ".NetworkInterfaceSet."
                                                + networkInterfacesListIndex + ".PrivateIpAddresses."
                                                + privateIpAddressesListIndex + ".Primary", StringUtils
                                                .fromBoolean(instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue
                                                        .primary()));
                                    }

                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                                + launchSpecificationsListIndex + ".NetworkInterfaceSet."
                                                + networkInterfacesListIndex + ".PrivateIpAddresses."
                                                + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils
                                                .fromString(instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue
                                                        .privateIpAddress()));
                                    }
                                    privateIpAddressesListIndex++;
                                }
                            }

                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex
                                        + ".SecondaryPrivateIpAddressCount", StringUtils
                                        .fromInteger(spotFleetLaunchSpecificationNetworkInterfacesListValue
                                                .secondaryPrivateIpAddressCount()));
                            }

                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.subnetId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications."
                                        + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex
                                        + ".SubnetId",
                                        StringUtils.fromString(spotFleetLaunchSpecificationNetworkInterfacesListValue.subnetId()));
                            }
                            networkInterfacesListIndex++;
                        }
                    }

                    SpotPlacement placement = spotFleetRequestConfigDataLaunchSpecificationsListValue.placement();
                    if (placement != null) {

                        if (placement.availabilityZone() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                    + ".Placement.AvailabilityZone", StringUtils.fromString(placement.availabilityZone()));
                        }

                        if (placement.groupName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                    + ".Placement.GroupName", StringUtils.fromString(placement.groupName()));
                        }

                        if (placement.tenancyString() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                    + ".Placement.Tenancy", StringUtils.fromString(placement.tenancyString()));
                        }
                    }

                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.ramdiskId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                + ".RamdiskId",
                                StringUtils.fromString(spotFleetRequestConfigDataLaunchSpecificationsListValue.ramdiskId()));
                    }

                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.spotPrice() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                + ".SpotPrice",
                                StringUtils.fromString(spotFleetRequestConfigDataLaunchSpecificationsListValue.spotPrice()));
                    }

                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.subnetId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                + ".SubnetId",
                                StringUtils.fromString(spotFleetRequestConfigDataLaunchSpecificationsListValue.subnetId()));
                    }

                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.userData() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                + ".UserData",
                                StringUtils.fromString(spotFleetRequestConfigDataLaunchSpecificationsListValue.userData()));
                    }

                    if (spotFleetRequestConfigDataLaunchSpecificationsListValue.weightedCapacity() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex
                                + ".WeightedCapacity", StringUtils
                                .fromDouble(spotFleetRequestConfigDataLaunchSpecificationsListValue.weightedCapacity()));
                    }
                    launchSpecificationsListIndex++;
                }
            }

            if (spotFleetRequestConfig.spotPrice() != null) {
                request.addParameter("SpotFleetRequestConfig.SpotPrice",
                        StringUtils.fromString(spotFleetRequestConfig.spotPrice()));
            }

            if (spotFleetRequestConfig.targetCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.TargetCapacity",
                        StringUtils.fromInteger(spotFleetRequestConfig.targetCapacity()));
            }

            if (spotFleetRequestConfig.terminateInstancesWithExpiration() != null) {
                request.addParameter("SpotFleetRequestConfig.TerminateInstancesWithExpiration",
                        StringUtils.fromBoolean(spotFleetRequestConfig.terminateInstancesWithExpiration()));
            }

            if (spotFleetRequestConfig.typeString() != null) {
                request.addParameter("SpotFleetRequestConfig.Type", StringUtils.fromString(spotFleetRequestConfig.typeString()));
            }

            if (spotFleetRequestConfig.validFrom() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidFrom",
                        StringUtils.fromInstant(spotFleetRequestConfig.validFrom()));
            }

            if (spotFleetRequestConfig.validUntil() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidUntil",
                        StringUtils.fromInstant(spotFleetRequestConfig.validUntil()));
            }

            if (spotFleetRequestConfig.replaceUnhealthyInstances() != null) {
                request.addParameter("SpotFleetRequestConfig.ReplaceUnhealthyInstances",
                        StringUtils.fromBoolean(spotFleetRequestConfig.replaceUnhealthyInstances()));
            }
        }

        return request;
    }

}
