/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * UnassignIpv6AddressesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UnassignIpv6AddressesResponseUnmarshaller implements
        Unmarshaller<UnassignIpv6AddressesResponse, StaxUnmarshallerContext> {

    public UnassignIpv6AddressesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        UnassignIpv6AddressesResponse.Builder unassignIpv6AddressesResponse = UnassignIpv6AddressesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> unassignedIpv6Addresses = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                unassignIpv6AddressesResponse.unassignedIpv6Addresses(unassignedIpv6Addresses);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("networkInterfaceId", targetDepth)) {
                    unassignIpv6AddressesResponse.networkInterfaceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("unassignedIpv6Addresses", targetDepth)) {
                    unassignedIpv6Addresses = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("unassignedIpv6Addresses/item", targetDepth)) {
                    unassignedIpv6Addresses.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    unassignIpv6AddressesResponse.unassignedIpv6Addresses(unassignedIpv6Addresses);
                    break;
                }
            }
        }
        return unassignIpv6AddressesResponse.build();
    }

    private static final UnassignIpv6AddressesResponseUnmarshaller INSTANCE = new UnassignIpv6AddressesResponseUnmarshaller();

    public static UnassignIpv6AddressesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
