/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateIamInstanceProfileRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateIamInstanceProfileRequest> {
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String instanceId;

    private AssociateIamInstanceProfileRequest(BuilderImpl builder) {
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceId = builder.instanceId;
    }

    public IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.iamInstanceProfile() == null ? 0 : this.iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateIamInstanceProfileRequest)) {
            return false;
        }
        AssociateIamInstanceProfileRequest other = (AssociateIamInstanceProfileRequest)((Object)obj);
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        return other.instanceId() == null || other.instanceId().equals(this.instanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.iamInstanceProfile()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamInstanceProfile": {
                return Optional.of(clazz.cast(this.iamInstanceProfile()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private IamInstanceProfileSpecification iamInstanceProfile;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateIamInstanceProfileRequest model) {
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.instanceId(model.instanceId);
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public AssociateIamInstanceProfileRequest build() {
            return new AssociateIamInstanceProfileRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateIamInstanceProfileRequest> {
        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        public Builder instanceId(String var1);
    }
}

