/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.BatchState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelSpotFleetRequestsSuccessItem
implements ToCopyableBuilder<Builder, CancelSpotFleetRequestsSuccessItem> {
    private final String currentSpotFleetRequestState;
    private final String previousSpotFleetRequestState;
    private final String spotFleetRequestId;

    private CancelSpotFleetRequestsSuccessItem(BuilderImpl builder) {
        this.currentSpotFleetRequestState = builder.currentSpotFleetRequestState;
        this.previousSpotFleetRequestState = builder.previousSpotFleetRequestState;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    public BatchState currentSpotFleetRequestState() {
        return BatchState.fromValue(this.currentSpotFleetRequestState);
    }

    public String currentSpotFleetRequestStateString() {
        return this.currentSpotFleetRequestState;
    }

    public BatchState previousSpotFleetRequestState() {
        return BatchState.fromValue(this.previousSpotFleetRequestState);
    }

    public String previousSpotFleetRequestStateString() {
        return this.previousSpotFleetRequestState;
    }

    public String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.currentSpotFleetRequestStateString() == null ? 0 : this.currentSpotFleetRequestStateString().hashCode());
        hashCode = 31 * hashCode + (this.previousSpotFleetRequestStateString() == null ? 0 : this.previousSpotFleetRequestStateString().hashCode());
        hashCode = 31 * hashCode + (this.spotFleetRequestId() == null ? 0 : this.spotFleetRequestId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsSuccessItem)) {
            return false;
        }
        CancelSpotFleetRequestsSuccessItem other = (CancelSpotFleetRequestsSuccessItem)obj;
        if (other.currentSpotFleetRequestStateString() == null ^ this.currentSpotFleetRequestStateString() == null) {
            return false;
        }
        if (other.currentSpotFleetRequestStateString() != null && !other.currentSpotFleetRequestStateString().equals(this.currentSpotFleetRequestStateString())) {
            return false;
        }
        if (other.previousSpotFleetRequestStateString() == null ^ this.previousSpotFleetRequestStateString() == null) {
            return false;
        }
        if (other.previousSpotFleetRequestStateString() != null && !other.previousSpotFleetRequestStateString().equals(this.previousSpotFleetRequestStateString())) {
            return false;
        }
        if (other.spotFleetRequestId() == null ^ this.spotFleetRequestId() == null) {
            return false;
        }
        return other.spotFleetRequestId() == null || other.spotFleetRequestId().equals(this.spotFleetRequestId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.currentSpotFleetRequestStateString() != null) {
            sb.append("CurrentSpotFleetRequestState: ").append(this.currentSpotFleetRequestStateString()).append(",");
        }
        if (this.previousSpotFleetRequestStateString() != null) {
            sb.append("PreviousSpotFleetRequestState: ").append(this.previousSpotFleetRequestStateString()).append(",");
        }
        if (this.spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(this.spotFleetRequestId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentSpotFleetRequestState": {
                return Optional.of(clazz.cast(this.currentSpotFleetRequestStateString()));
            }
            case "PreviousSpotFleetRequestState": {
                return Optional.of(clazz.cast(this.previousSpotFleetRequestStateString()));
            }
            case "SpotFleetRequestId": {
                return Optional.of(clazz.cast(this.spotFleetRequestId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String currentSpotFleetRequestState;
        private String previousSpotFleetRequestState;
        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsSuccessItem model) {
            this.currentSpotFleetRequestState(model.currentSpotFleetRequestState);
            this.previousSpotFleetRequestState(model.previousSpotFleetRequestState);
            this.spotFleetRequestId(model.spotFleetRequestId);
        }

        public final String getCurrentSpotFleetRequestState() {
            return this.currentSpotFleetRequestState;
        }

        @Override
        public final Builder currentSpotFleetRequestState(String currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState = currentSpotFleetRequestState;
            return this;
        }

        @Override
        public final Builder currentSpotFleetRequestState(BatchState currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState(currentSpotFleetRequestState.toString());
            return this;
        }

        public final void setCurrentSpotFleetRequestState(String currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState = currentSpotFleetRequestState;
        }

        public final String getPreviousSpotFleetRequestState() {
            return this.previousSpotFleetRequestState;
        }

        @Override
        public final Builder previousSpotFleetRequestState(String previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState = previousSpotFleetRequestState;
            return this;
        }

        @Override
        public final Builder previousSpotFleetRequestState(BatchState previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState(previousSpotFleetRequestState.toString());
            return this;
        }

        public final void setPreviousSpotFleetRequestState(String previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState = previousSpotFleetRequestState;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public CancelSpotFleetRequestsSuccessItem build() {
            return new CancelSpotFleetRequestsSuccessItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CancelSpotFleetRequestsSuccessItem> {
        public Builder currentSpotFleetRequestState(String var1);

        public Builder currentSpotFleetRequestState(BatchState var1);

        public Builder previousSpotFleetRequestState(String var1);

        public Builder previousSpotFleetRequestState(BatchState var1);

        public Builder spotFleetRequestId(String var1);
    }
}

