/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.IcmpTypeCode;
import software.amazon.awssdk.services.ec2.model.PortRange;
import software.amazon.awssdk.services.ec2.model.RuleAction;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateNetworkAclEntryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateNetworkAclEntryRequest> {
    private final String cidrBlock;
    private final Boolean egress;
    private final IcmpTypeCode icmpTypeCode;
    private final String ipv6CidrBlock;
    private final String networkAclId;
    private final PortRange portRange;
    private final String protocol;
    private final String ruleAction;
    private final Integer ruleNumber;

    private CreateNetworkAclEntryRequest(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.egress = builder.egress;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.networkAclId = builder.networkAclId;
        this.portRange = builder.portRange;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.ruleNumber = builder.ruleNumber;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public Boolean egress() {
        return this.egress;
    }

    public IcmpTypeCode icmpTypeCode() {
        return this.icmpTypeCode;
    }

    public String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public String networkAclId() {
        return this.networkAclId;
    }

    public PortRange portRange() {
        return this.portRange;
    }

    public String protocol() {
        return this.protocol;
    }

    public RuleAction ruleAction() {
        return RuleAction.fromValue(this.ruleAction);
    }

    public String ruleActionString() {
        return this.ruleAction;
    }

    public Integer ruleNumber() {
        return this.ruleNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cidrBlock() == null ? 0 : this.cidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.egress() == null ? 0 : this.egress().hashCode());
        hashCode = 31 * hashCode + (this.icmpTypeCode() == null ? 0 : this.icmpTypeCode().hashCode());
        hashCode = 31 * hashCode + (this.ipv6CidrBlock() == null ? 0 : this.ipv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.networkAclId() == null ? 0 : this.networkAclId().hashCode());
        hashCode = 31 * hashCode + (this.portRange() == null ? 0 : this.portRange().hashCode());
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        hashCode = 31 * hashCode + (this.ruleActionString() == null ? 0 : this.ruleActionString().hashCode());
        hashCode = 31 * hashCode + (this.ruleNumber() == null ? 0 : this.ruleNumber().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkAclEntryRequest)) {
            return false;
        }
        CreateNetworkAclEntryRequest other = (CreateNetworkAclEntryRequest)((Object)obj);
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.egress() == null ^ this.egress() == null) {
            return false;
        }
        if (other.egress() != null && !other.egress().equals(this.egress())) {
            return false;
        }
        if (other.icmpTypeCode() == null ^ this.icmpTypeCode() == null) {
            return false;
        }
        if (other.icmpTypeCode() != null && !other.icmpTypeCode().equals(this.icmpTypeCode())) {
            return false;
        }
        if (other.ipv6CidrBlock() == null ^ this.ipv6CidrBlock() == null) {
            return false;
        }
        if (other.ipv6CidrBlock() != null && !other.ipv6CidrBlock().equals(this.ipv6CidrBlock())) {
            return false;
        }
        if (other.networkAclId() == null ^ this.networkAclId() == null) {
            return false;
        }
        if (other.networkAclId() != null && !other.networkAclId().equals(this.networkAclId())) {
            return false;
        }
        if (other.portRange() == null ^ this.portRange() == null) {
            return false;
        }
        if (other.portRange() != null && !other.portRange().equals(this.portRange())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.ruleActionString() == null ^ this.ruleActionString() == null) {
            return false;
        }
        if (other.ruleActionString() != null && !other.ruleActionString().equals(this.ruleActionString())) {
            return false;
        }
        if (other.ruleNumber() == null ^ this.ruleNumber() == null) {
            return false;
        }
        return other.ruleNumber() == null || other.ruleNumber().equals(this.ruleNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.cidrBlock()).append(",");
        }
        if (this.egress() != null) {
            sb.append("Egress: ").append(this.egress()).append(",");
        }
        if (this.icmpTypeCode() != null) {
            sb.append("IcmpTypeCode: ").append(this.icmpTypeCode()).append(",");
        }
        if (this.ipv6CidrBlock() != null) {
            sb.append("Ipv6CidrBlock: ").append(this.ipv6CidrBlock()).append(",");
        }
        if (this.networkAclId() != null) {
            sb.append("NetworkAclId: ").append(this.networkAclId()).append(",");
        }
        if (this.portRange() != null) {
            sb.append("PortRange: ").append(this.portRange()).append(",");
        }
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        if (this.ruleActionString() != null) {
            sb.append("RuleAction: ").append(this.ruleActionString()).append(",");
        }
        if (this.ruleNumber() != null) {
            sb.append("RuleNumber: ").append(this.ruleNumber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.of(clazz.cast(this.cidrBlock()));
            }
            case "Egress": {
                return Optional.of(clazz.cast(this.egress()));
            }
            case "IcmpTypeCode": {
                return Optional.of(clazz.cast(this.icmpTypeCode()));
            }
            case "Ipv6CidrBlock": {
                return Optional.of(clazz.cast(this.ipv6CidrBlock()));
            }
            case "NetworkAclId": {
                return Optional.of(clazz.cast(this.networkAclId()));
            }
            case "PortRange": {
                return Optional.of(clazz.cast(this.portRange()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocol()));
            }
            case "RuleAction": {
                return Optional.of(clazz.cast(this.ruleActionString()));
            }
            case "RuleNumber": {
                return Optional.of(clazz.cast(this.ruleNumber()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cidrBlock;
        private Boolean egress;
        private IcmpTypeCode icmpTypeCode;
        private String ipv6CidrBlock;
        private String networkAclId;
        private PortRange portRange;
        private String protocol;
        private String ruleAction;
        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkAclEntryRequest model) {
            this.cidrBlock(model.cidrBlock);
            this.egress(model.egress);
            this.icmpTypeCode(model.icmpTypeCode);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.networkAclId(model.networkAclId);
            this.portRange(model.portRange);
            this.protocol(model.protocol);
            this.ruleAction(model.ruleAction);
            this.ruleNumber(model.ruleNumber);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getEgress() {
            return this.egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        public final IcmpTypeCode.Builder getIcmpTypeCode() {
            return this.icmpTypeCode != null ? this.icmpTypeCode.toBuilder() : null;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final void setIcmpTypeCode(IcmpTypeCode.BuilderImpl icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode != null ? icmpTypeCode.build() : null;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final PortRange.Builder getPortRange() {
            return this.portRange != null ? this.portRange.toBuilder() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction(ruleAction.toString());
            return this;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        public final Integer getRuleNumber() {
            return this.ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        public CreateNetworkAclEntryRequest build() {
            return new CreateNetworkAclEntryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateNetworkAclEntryRequest> {
        public Builder cidrBlock(String var1);

        public Builder egress(Boolean var1);

        public Builder icmpTypeCode(IcmpTypeCode var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder networkAclId(String var1);

        public Builder portRange(PortRange var1);

        public Builder protocol(String var1);

        public Builder ruleAction(String var1);

        public Builder ruleAction(RuleAction var1);

        public Builder ruleNumber(Integer var1);
    }
}

