/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.PrefixList;
import software.amazon.awssdk.services.ec2.model.PrefixListSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePrefixListsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribePrefixListsResponse> {
    private final String nextToken;
    private final List<PrefixList> prefixLists;

    private DescribePrefixListsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.prefixLists = builder.prefixLists;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<PrefixList> prefixLists() {
        return this.prefixLists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.prefixLists() == null ? 0 : this.prefixLists().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrefixListsResponse)) {
            return false;
        }
        DescribePrefixListsResponse other = (DescribePrefixListsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.prefixLists() == null ^ this.prefixLists() == null) {
            return false;
        }
        return other.prefixLists() == null || other.prefixLists().equals(this.prefixLists());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.prefixLists() != null) {
            sb.append("PrefixLists: ").append(this.prefixLists()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "PrefixLists": {
                return Optional.of(clazz.cast(this.prefixLists()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PrefixList> prefixLists;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrefixListsResponse model) {
            this.nextToken(model.nextToken);
            this.prefixLists(model.prefixLists);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<PrefixList.Builder> getPrefixLists() {
            return this.prefixLists != null ? (Collection)this.prefixLists.stream().map(PrefixList::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder prefixLists(Collection<PrefixList> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copy(prefixLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixLists(PrefixList ... prefixLists) {
            this.prefixLists(Arrays.asList(prefixLists));
            return this;
        }

        public final void setPrefixLists(Collection<PrefixList.BuilderImpl> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copyFromBuilder(prefixLists);
        }

        public DescribePrefixListsResponse build() {
            return new DescribePrefixListsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePrefixListsResponse> {
        public Builder nextToken(String var1);

        public Builder prefixLists(Collection<PrefixList> var1);

        public Builder prefixLists(PrefixList ... var1);
    }
}

