/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.InstanceTypeListCopier;
import software.amazon.awssdk.services.ec2.model.ProductDescriptionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSpotPriceHistoryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeSpotPriceHistoryRequest> {
    private final List<Filter> filters;
    private final String availabilityZone;
    private final Instant endTime;
    private final List<String> instanceTypes;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> productDescriptions;
    private final Instant startTime;

    private DescribeSpotPriceHistoryRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.availabilityZone = builder.availabilityZone;
        this.endTime = builder.endTime;
        this.instanceTypes = builder.instanceTypes;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.productDescriptions = builder.productDescriptions;
        this.startTime = builder.startTime;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public List<InstanceType> instanceTypes() {
        return TypeConverter.convert(this.instanceTypes, InstanceType::fromValue);
    }

    public List<String> instanceTypesStrings() {
        return this.instanceTypes;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> productDescriptions() {
        return this.productDescriptions;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.instanceTypesStrings() == null ? 0 : this.instanceTypesStrings().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.productDescriptions() == null ? 0 : this.productDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotPriceHistoryRequest)) {
            return false;
        }
        DescribeSpotPriceHistoryRequest other = (DescribeSpotPriceHistoryRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.instanceTypesStrings() == null ^ this.instanceTypesStrings() == null) {
            return false;
        }
        if (other.instanceTypesStrings() != null && !other.instanceTypesStrings().equals(this.instanceTypesStrings())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.productDescriptions() == null ^ this.productDescriptions() == null) {
            return false;
        }
        if (other.productDescriptions() != null && !other.productDescriptions().equals(this.productDescriptions())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        return other.startTime() == null || other.startTime().equals(this.startTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.instanceTypesStrings() != null) {
            sb.append("InstanceTypes: ").append(this.instanceTypesStrings()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.productDescriptions() != null) {
            sb.append("ProductDescriptions: ").append(this.productDescriptions()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "InstanceTypes": {
                return Optional.of(clazz.cast(this.instanceTypesStrings()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "ProductDescriptions": {
                return Optional.of(clazz.cast(this.productDescriptions()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private String availabilityZone;
        private Instant endTime;
        private List<String> instanceTypes;
        private Integer maxResults;
        private String nextToken;
        private List<String> productDescriptions;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotPriceHistoryRequest model) {
            this.filters(model.filters);
            this.availabilityZone(model.availabilityZone);
            this.endTime(model.endTime);
            this.instanceTypes(model.instanceTypes);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.productDescriptions(model.productDescriptions);
            this.startTime(model.startTime);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<String> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getProductDescriptions() {
            return this.productDescriptions;
        }

        @Override
        public final Builder productDescriptions(Collection<String> productDescriptions) {
            this.productDescriptions = ProductDescriptionListCopier.copy(productDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productDescriptions(String ... productDescriptions) {
            this.productDescriptions(Arrays.asList(productDescriptions));
            return this;
        }

        public final void setProductDescriptions(Collection<String> productDescriptions) {
            this.productDescriptions = ProductDescriptionListCopier.copy(productDescriptions);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public DescribeSpotPriceHistoryRequest build() {
            return new DescribeSpotPriceHistoryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSpotPriceHistoryRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder availabilityZone(String var1);

        public Builder endTime(Instant var1);

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder productDescriptions(Collection<String> var1);

        public Builder productDescriptions(String ... var1);

        public Builder startTime(Instant var1);
    }
}

