/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.VpnConnectionIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpnConnectionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeVpnConnectionsRequest> {
    private final List<Filter> filters;
    private final List<String> vpnConnectionIds;

    private DescribeVpnConnectionsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.vpnConnectionIds = builder.vpnConnectionIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> vpnConnectionIds() {
        return this.vpnConnectionIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.vpnConnectionIds() == null ? 0 : this.vpnConnectionIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsRequest)) {
            return false;
        }
        DescribeVpnConnectionsRequest other = (DescribeVpnConnectionsRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.vpnConnectionIds() == null ^ this.vpnConnectionIds() == null) {
            return false;
        }
        return other.vpnConnectionIds() == null || other.vpnConnectionIds().equals(this.vpnConnectionIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.vpnConnectionIds() != null) {
            sb.append("VpnConnectionIds: ").append(this.vpnConnectionIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "VpnConnectionIds": {
                return Optional.of(clazz.cast(this.vpnConnectionIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> vpnConnectionIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConnectionsRequest model) {
            this.filters(model.filters);
            this.vpnConnectionIds(model.vpnConnectionIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getVpnConnectionIds() {
            return this.vpnConnectionIds;
        }

        @Override
        public final Builder vpnConnectionIds(Collection<String> vpnConnectionIds) {
            this.vpnConnectionIds = VpnConnectionIdStringListCopier.copy(vpnConnectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnectionIds(String ... vpnConnectionIds) {
            this.vpnConnectionIds(Arrays.asList(vpnConnectionIds));
            return this;
        }

        public final void setVpnConnectionIds(Collection<String> vpnConnectionIds) {
            this.vpnConnectionIds = VpnConnectionIdStringListCopier.copy(vpnConnectionIds);
        }

        public DescribeVpnConnectionsRequest build() {
            return new DescribeVpnConnectionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpnConnectionsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder vpnConnectionIds(Collection<String> var1);

        public Builder vpnConnectionIds(String ... var1);
    }
}

