/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.PaymentOption;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HostOffering
implements ToCopyableBuilder<Builder, HostOffering> {
    private final String currencyCode;
    private final Integer duration;
    private final String hourlyPrice;
    private final String instanceFamily;
    private final String offeringId;
    private final String paymentOption;
    private final String upfrontPrice;

    private HostOffering(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.upfrontPrice = builder.upfrontPrice;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeString() {
        return this.currencyCode;
    }

    public Integer duration() {
        return this.duration;
    }

    public String hourlyPrice() {
        return this.hourlyPrice;
    }

    public String instanceFamily() {
        return this.instanceFamily;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public String paymentOptionString() {
        return this.paymentOption;
    }

    public String upfrontPrice() {
        return this.upfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.currencyCodeString() == null ? 0 : this.currencyCodeString().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.hourlyPrice() == null ? 0 : this.hourlyPrice().hashCode());
        hashCode = 31 * hashCode + (this.instanceFamily() == null ? 0 : this.instanceFamily().hashCode());
        hashCode = 31 * hashCode + (this.offeringId() == null ? 0 : this.offeringId().hashCode());
        hashCode = 31 * hashCode + (this.paymentOptionString() == null ? 0 : this.paymentOptionString().hashCode());
        hashCode = 31 * hashCode + (this.upfrontPrice() == null ? 0 : this.upfrontPrice().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostOffering)) {
            return false;
        }
        HostOffering other = (HostOffering)obj;
        if (other.currencyCodeString() == null ^ this.currencyCodeString() == null) {
            return false;
        }
        if (other.currencyCodeString() != null && !other.currencyCodeString().equals(this.currencyCodeString())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.hourlyPrice() == null ^ this.hourlyPrice() == null) {
            return false;
        }
        if (other.hourlyPrice() != null && !other.hourlyPrice().equals(this.hourlyPrice())) {
            return false;
        }
        if (other.instanceFamily() == null ^ this.instanceFamily() == null) {
            return false;
        }
        if (other.instanceFamily() != null && !other.instanceFamily().equals(this.instanceFamily())) {
            return false;
        }
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        if (other.offeringId() != null && !other.offeringId().equals(this.offeringId())) {
            return false;
        }
        if (other.paymentOptionString() == null ^ this.paymentOptionString() == null) {
            return false;
        }
        if (other.paymentOptionString() != null && !other.paymentOptionString().equals(this.paymentOptionString())) {
            return false;
        }
        if (other.upfrontPrice() == null ^ this.upfrontPrice() == null) {
            return false;
        }
        return other.upfrontPrice() == null || other.upfrontPrice().equals(this.upfrontPrice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.currencyCodeString() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCodeString()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.hourlyPrice() != null) {
            sb.append("HourlyPrice: ").append(this.hourlyPrice()).append(",");
        }
        if (this.instanceFamily() != null) {
            sb.append("InstanceFamily: ").append(this.instanceFamily()).append(",");
        }
        if (this.offeringId() != null) {
            sb.append("OfferingId: ").append(this.offeringId()).append(",");
        }
        if (this.paymentOptionString() != null) {
            sb.append("PaymentOption: ").append(this.paymentOptionString()).append(",");
        }
        if (this.upfrontPrice() != null) {
            sb.append("UpfrontPrice: ").append(this.upfrontPrice()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeString()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "HourlyPrice": {
                return Optional.of(clazz.cast(this.hourlyPrice()));
            }
            case "InstanceFamily": {
                return Optional.of(clazz.cast(this.instanceFamily()));
            }
            case "OfferingId": {
                return Optional.of(clazz.cast(this.offeringId()));
            }
            case "PaymentOption": {
                return Optional.of(clazz.cast(this.paymentOptionString()));
            }
            case "UpfrontPrice": {
                return Optional.of(clazz.cast(this.upfrontPrice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private Integer duration;
        private String hourlyPrice;
        private String instanceFamily;
        private String offeringId;
        private String paymentOption;
        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HostOffering model) {
            this.currencyCode(model.currencyCode);
            this.duration(model.duration);
            this.hourlyPrice(model.hourlyPrice);
            this.instanceFamily(model.instanceFamily);
            this.offeringId(model.offeringId);
            this.paymentOption(model.paymentOption);
            this.upfrontPrice(model.upfrontPrice);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final String getUpfrontPrice() {
            return this.upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        public HostOffering build() {
            return new HostOffering(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HostOffering> {
        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder duration(Integer var1);

        public Builder hourlyPrice(String var1);

        public Builder instanceFamily(String var1);

        public Builder offeringId(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder upfrontPrice(String var1);
    }
}

