/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KeyPair
implements ToCopyableBuilder<Builder, KeyPair> {
    private final String keyFingerprint;
    private final String keyMaterial;
    private final String keyName;

    private KeyPair(BuilderImpl builder) {
        this.keyFingerprint = builder.keyFingerprint;
        this.keyMaterial = builder.keyMaterial;
        this.keyName = builder.keyName;
    }

    public String keyFingerprint() {
        return this.keyFingerprint;
    }

    public String keyMaterial() {
        return this.keyMaterial;
    }

    public String keyName() {
        return this.keyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyFingerprint() == null ? 0 : this.keyFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.keyMaterial() == null ? 0 : this.keyMaterial().hashCode());
        hashCode = 31 * hashCode + (this.keyName() == null ? 0 : this.keyName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair)obj;
        if (other.keyFingerprint() == null ^ this.keyFingerprint() == null) {
            return false;
        }
        if (other.keyFingerprint() != null && !other.keyFingerprint().equals(this.keyFingerprint())) {
            return false;
        }
        if (other.keyMaterial() == null ^ this.keyMaterial() == null) {
            return false;
        }
        if (other.keyMaterial() != null && !other.keyMaterial().equals(this.keyMaterial())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        return other.keyName() == null || other.keyName().equals(this.keyName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyFingerprint() != null) {
            sb.append("KeyFingerprint: ").append(this.keyFingerprint()).append(",");
        }
        if (this.keyMaterial() != null) {
            sb.append("KeyMaterial: ").append(this.keyMaterial()).append(",");
        }
        if (this.keyName() != null) {
            sb.append("KeyName: ").append(this.keyName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyFingerprint": {
                return Optional.of(clazz.cast(this.keyFingerprint()));
            }
            case "KeyMaterial": {
                return Optional.of(clazz.cast(this.keyMaterial()));
            }
            case "KeyName": {
                return Optional.of(clazz.cast(this.keyName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String keyFingerprint;
        private String keyMaterial;
        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPair model) {
            this.keyFingerprint(model.keyFingerprint);
            this.keyMaterial(model.keyMaterial);
            this.keyName(model.keyName);
        }

        public final String getKeyFingerprint() {
            return this.keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        public final String getKeyMaterial() {
            return this.keyMaterial;
        }

        @Override
        public final Builder keyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
            return this;
        }

        public final void setKeyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public KeyPair build() {
            return new KeyPair(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeyPair> {
        public Builder keyFingerprint(String var1);

        public Builder keyMaterial(String var1);

        public Builder keyName(String var1);
    }
}

