/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkInterfaceAssociation
implements ToCopyableBuilder<Builder, NetworkInterfaceAssociation> {
    private final String allocationId;
    private final String associationId;
    private final String ipOwnerId;
    private final String publicDnsName;
    private final String publicIp;

    private NetworkInterfaceAssociation(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.associationId = builder.associationId;
        this.ipOwnerId = builder.ipOwnerId;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public String associationId() {
        return this.associationId;
    }

    public String ipOwnerId() {
        return this.ipOwnerId;
    }

    public String publicDnsName() {
        return this.publicDnsName;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.allocationId() == null ? 0 : this.allocationId().hashCode());
        hashCode = 31 * hashCode + (this.associationId() == null ? 0 : this.associationId().hashCode());
        hashCode = 31 * hashCode + (this.ipOwnerId() == null ? 0 : this.ipOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.publicDnsName() == null ? 0 : this.publicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.publicIp() == null ? 0 : this.publicIp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAssociation)) {
            return false;
        }
        NetworkInterfaceAssociation other = (NetworkInterfaceAssociation)obj;
        if (other.allocationId() == null ^ this.allocationId() == null) {
            return false;
        }
        if (other.allocationId() != null && !other.allocationId().equals(this.allocationId())) {
            return false;
        }
        if (other.associationId() == null ^ this.associationId() == null) {
            return false;
        }
        if (other.associationId() != null && !other.associationId().equals(this.associationId())) {
            return false;
        }
        if (other.ipOwnerId() == null ^ this.ipOwnerId() == null) {
            return false;
        }
        if (other.ipOwnerId() != null && !other.ipOwnerId().equals(this.ipOwnerId())) {
            return false;
        }
        if (other.publicDnsName() == null ^ this.publicDnsName() == null) {
            return false;
        }
        if (other.publicDnsName() != null && !other.publicDnsName().equals(this.publicDnsName())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        return other.publicIp() == null || other.publicIp().equals(this.publicIp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.allocationId() != null) {
            sb.append("AllocationId: ").append(this.allocationId()).append(",");
        }
        if (this.associationId() != null) {
            sb.append("AssociationId: ").append(this.associationId()).append(",");
        }
        if (this.ipOwnerId() != null) {
            sb.append("IpOwnerId: ").append(this.ipOwnerId()).append(",");
        }
        if (this.publicDnsName() != null) {
            sb.append("PublicDnsName: ").append(this.publicDnsName()).append(",");
        }
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.of(clazz.cast(this.allocationId()));
            }
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "IpOwnerId": {
                return Optional.of(clazz.cast(this.ipOwnerId()));
            }
            case "PublicDnsName": {
                return Optional.of(clazz.cast(this.publicDnsName()));
            }
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationId;
        private String associationId;
        private String ipOwnerId;
        private String publicDnsName;
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAssociation model) {
            this.allocationId(model.allocationId);
            this.associationId(model.associationId);
            this.ipOwnerId(model.ipOwnerId);
            this.publicDnsName(model.publicDnsName);
            this.publicIp(model.publicIp);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getIpOwnerId() {
            return this.ipOwnerId;
        }

        @Override
        public final Builder ipOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
            return this;
        }

        public final void setIpOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
        }

        public final String getPublicDnsName() {
            return this.publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public NetworkInterfaceAssociation build() {
            return new NetworkInterfaceAssociation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkInterfaceAssociation> {
        public Builder allocationId(String var1);

        public Builder associationId(String var1);

        public Builder ipOwnerId(String var1);

        public Builder publicDnsName(String var1);

        public Builder publicIp(String var1);
    }
}

