/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.Purchase;
import software.amazon.awssdk.services.ec2.model.PurchaseSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseHostReservationResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PurchaseHostReservationResponse> {
    private final String clientToken;
    private final String currencyCode;
    private final List<Purchase> purchase;
    private final String totalHourlyPrice;
    private final String totalUpfrontPrice;

    private PurchaseHostReservationResponse(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.currencyCode = builder.currencyCode;
        this.purchase = builder.purchase;
        this.totalHourlyPrice = builder.totalHourlyPrice;
        this.totalUpfrontPrice = builder.totalUpfrontPrice;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeString() {
        return this.currencyCode;
    }

    public List<Purchase> purchase() {
        return this.purchase;
    }

    public String totalHourlyPrice() {
        return this.totalHourlyPrice;
    }

    public String totalUpfrontPrice() {
        return this.totalUpfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.currencyCodeString() == null ? 0 : this.currencyCodeString().hashCode());
        hashCode = 31 * hashCode + (this.purchase() == null ? 0 : this.purchase().hashCode());
        hashCode = 31 * hashCode + (this.totalHourlyPrice() == null ? 0 : this.totalHourlyPrice().hashCode());
        hashCode = 31 * hashCode + (this.totalUpfrontPrice() == null ? 0 : this.totalUpfrontPrice().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseHostReservationResponse)) {
            return false;
        }
        PurchaseHostReservationResponse other = (PurchaseHostReservationResponse)((Object)obj);
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.currencyCodeString() == null ^ this.currencyCodeString() == null) {
            return false;
        }
        if (other.currencyCodeString() != null && !other.currencyCodeString().equals(this.currencyCodeString())) {
            return false;
        }
        if (other.purchase() == null ^ this.purchase() == null) {
            return false;
        }
        if (other.purchase() != null && !other.purchase().equals(this.purchase())) {
            return false;
        }
        if (other.totalHourlyPrice() == null ^ this.totalHourlyPrice() == null) {
            return false;
        }
        if (other.totalHourlyPrice() != null && !other.totalHourlyPrice().equals(this.totalHourlyPrice())) {
            return false;
        }
        if (other.totalUpfrontPrice() == null ^ this.totalUpfrontPrice() == null) {
            return false;
        }
        return other.totalUpfrontPrice() == null || other.totalUpfrontPrice().equals(this.totalUpfrontPrice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.currencyCodeString() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCodeString()).append(",");
        }
        if (this.purchase() != null) {
            sb.append("Purchase: ").append(this.purchase()).append(",");
        }
        if (this.totalHourlyPrice() != null) {
            sb.append("TotalHourlyPrice: ").append(this.totalHourlyPrice()).append(",");
        }
        if (this.totalUpfrontPrice() != null) {
            sb.append("TotalUpfrontPrice: ").append(this.totalUpfrontPrice()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeString()));
            }
            case "Purchase": {
                return Optional.of(clazz.cast(this.purchase()));
            }
            case "TotalHourlyPrice": {
                return Optional.of(clazz.cast(this.totalHourlyPrice()));
            }
            case "TotalUpfrontPrice": {
                return Optional.of(clazz.cast(this.totalUpfrontPrice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private String currencyCode;
        private List<Purchase> purchase;
        private String totalHourlyPrice;
        private String totalUpfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseHostReservationResponse model) {
            this.clientToken(model.clientToken);
            this.currencyCode(model.currencyCode);
            this.purchase(model.purchase);
            this.totalHourlyPrice(model.totalHourlyPrice);
            this.totalUpfrontPrice(model.totalUpfrontPrice);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Collection<Purchase.Builder> getPurchase() {
            return this.purchase != null ? (Collection)this.purchase.stream().map(Purchase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder purchase(Collection<Purchase> purchase) {
            this.purchase = PurchaseSetCopier.copy(purchase);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Purchase ... purchase) {
            this.purchase(Arrays.asList(purchase));
            return this;
        }

        public final void setPurchase(Collection<Purchase.BuilderImpl> purchase) {
            this.purchase = PurchaseSetCopier.copyFromBuilder(purchase);
        }

        public final String getTotalHourlyPrice() {
            return this.totalHourlyPrice;
        }

        @Override
        public final Builder totalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
            return this;
        }

        public final void setTotalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
        }

        public final String getTotalUpfrontPrice() {
            return this.totalUpfrontPrice;
        }

        @Override
        public final Builder totalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
            return this;
        }

        public final void setTotalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
        }

        public PurchaseHostReservationResponse build() {
            return new PurchaseHostReservationResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PurchaseHostReservationResponse> {
        public Builder clientToken(String var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder purchase(Collection<Purchase> var1);

        public Builder purchase(Purchase ... var1);

        public Builder totalHourlyPrice(String var1);

        public Builder totalUpfrontPrice(String var1);
    }
}

