/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseRequest
implements ToCopyableBuilder<Builder, PurchaseRequest> {
    private final Integer instanceCount;
    private final String purchaseToken;

    private PurchaseRequest(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.purchaseToken = builder.purchaseToken;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public String purchaseToken() {
        return this.purchaseToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.purchaseToken() == null ? 0 : this.purchaseToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseRequest)) {
            return false;
        }
        PurchaseRequest other = (PurchaseRequest)obj;
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.purchaseToken() == null ^ this.purchaseToken() == null) {
            return false;
        }
        return other.purchaseToken() == null || other.purchaseToken().equals(this.purchaseToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.purchaseToken() != null) {
            sb.append("PurchaseToken: ").append(this.purchaseToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "PurchaseToken": {
                return Optional.of(clazz.cast(this.purchaseToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String purchaseToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseRequest model) {
            this.instanceCount(model.instanceCount);
            this.purchaseToken(model.purchaseToken);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getPurchaseToken() {
            return this.purchaseToken;
        }

        @Override
        public final Builder purchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
            return this;
        }

        public final void setPurchaseToken(String purchaseToken) {
            this.purchaseToken = purchaseToken;
        }

        public PurchaseRequest build() {
            return new PurchaseRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PurchaseRequest> {
        public Builder instanceCount(Integer var1);

        public Builder purchaseToken(String var1);
    }
}

