/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.AllocationStrategy;
import software.amazon.awssdk.services.ec2.model.ExcessCapacityTerminationPolicy;
import software.amazon.awssdk.services.ec2.model.FleetType;
import software.amazon.awssdk.services.ec2.model.LaunchSpecsListCopier;
import software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotFleetRequestConfigData
implements ToCopyableBuilder<Builder, SpotFleetRequestConfigData> {
    private final String allocationStrategy;
    private final String clientToken;
    private final String excessCapacityTerminationPolicy;
    private final Double fulfilledCapacity;
    private final String iamFleetRole;
    private final List<SpotFleetLaunchSpecification> launchSpecifications;
    private final String spotPrice;
    private final Integer targetCapacity;
    private final Boolean terminateInstancesWithExpiration;
    private final String type;
    private final Instant validFrom;
    private final Instant validUntil;
    private final Boolean replaceUnhealthyInstances;

    private SpotFleetRequestConfigData(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.clientToken = builder.clientToken;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.fulfilledCapacity = builder.fulfilledCapacity;
        this.iamFleetRole = builder.iamFleetRole;
        this.launchSpecifications = builder.launchSpecifications;
        this.spotPrice = builder.spotPrice;
        this.targetCapacity = builder.targetCapacity;
        this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
    }

    public AllocationStrategy allocationStrategy() {
        return AllocationStrategy.fromValue(this.allocationStrategy);
    }

    public String allocationStrategyString() {
        return this.allocationStrategy;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return ExcessCapacityTerminationPolicy.fromValue(this.excessCapacityTerminationPolicy);
    }

    public String excessCapacityTerminationPolicyString() {
        return this.excessCapacityTerminationPolicy;
    }

    public Double fulfilledCapacity() {
        return this.fulfilledCapacity;
    }

    public String iamFleetRole() {
        return this.iamFleetRole;
    }

    public List<SpotFleetLaunchSpecification> launchSpecifications() {
        return this.launchSpecifications;
    }

    public String spotPrice() {
        return this.spotPrice;
    }

    public Integer targetCapacity() {
        return this.targetCapacity;
    }

    public Boolean terminateInstancesWithExpiration() {
        return this.terminateInstancesWithExpiration;
    }

    public FleetType type() {
        return FleetType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Instant validFrom() {
        return this.validFrom;
    }

    public Instant validUntil() {
        return this.validUntil;
    }

    public Boolean replaceUnhealthyInstances() {
        return this.replaceUnhealthyInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.allocationStrategyString() == null ? 0 : this.allocationStrategyString().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.excessCapacityTerminationPolicyString() == null ? 0 : this.excessCapacityTerminationPolicyString().hashCode());
        hashCode = 31 * hashCode + (this.fulfilledCapacity() == null ? 0 : this.fulfilledCapacity().hashCode());
        hashCode = 31 * hashCode + (this.iamFleetRole() == null ? 0 : this.iamFleetRole().hashCode());
        hashCode = 31 * hashCode + (this.launchSpecifications() == null ? 0 : this.launchSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.spotPrice() == null ? 0 : this.spotPrice().hashCode());
        hashCode = 31 * hashCode + (this.targetCapacity() == null ? 0 : this.targetCapacity().hashCode());
        hashCode = 31 * hashCode + (this.terminateInstancesWithExpiration() == null ? 0 : this.terminateInstancesWithExpiration().hashCode());
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.validFrom() == null ? 0 : this.validFrom().hashCode());
        hashCode = 31 * hashCode + (this.validUntil() == null ? 0 : this.validUntil().hashCode());
        hashCode = 31 * hashCode + (this.replaceUnhealthyInstances() == null ? 0 : this.replaceUnhealthyInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfigData)) {
            return false;
        }
        SpotFleetRequestConfigData other = (SpotFleetRequestConfigData)obj;
        if (other.allocationStrategyString() == null ^ this.allocationStrategyString() == null) {
            return false;
        }
        if (other.allocationStrategyString() != null && !other.allocationStrategyString().equals(this.allocationStrategyString())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.excessCapacityTerminationPolicyString() == null ^ this.excessCapacityTerminationPolicyString() == null) {
            return false;
        }
        if (other.excessCapacityTerminationPolicyString() != null && !other.excessCapacityTerminationPolicyString().equals(this.excessCapacityTerminationPolicyString())) {
            return false;
        }
        if (other.fulfilledCapacity() == null ^ this.fulfilledCapacity() == null) {
            return false;
        }
        if (other.fulfilledCapacity() != null && !other.fulfilledCapacity().equals(this.fulfilledCapacity())) {
            return false;
        }
        if (other.iamFleetRole() == null ^ this.iamFleetRole() == null) {
            return false;
        }
        if (other.iamFleetRole() != null && !other.iamFleetRole().equals(this.iamFleetRole())) {
            return false;
        }
        if (other.launchSpecifications() == null ^ this.launchSpecifications() == null) {
            return false;
        }
        if (other.launchSpecifications() != null && !other.launchSpecifications().equals(this.launchSpecifications())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.targetCapacity() == null ^ this.targetCapacity() == null) {
            return false;
        }
        if (other.targetCapacity() != null && !other.targetCapacity().equals(this.targetCapacity())) {
            return false;
        }
        if (other.terminateInstancesWithExpiration() == null ^ this.terminateInstancesWithExpiration() == null) {
            return false;
        }
        if (other.terminateInstancesWithExpiration() != null && !other.terminateInstancesWithExpiration().equals(this.terminateInstancesWithExpiration())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.validFrom() == null ^ this.validFrom() == null) {
            return false;
        }
        if (other.validFrom() != null && !other.validFrom().equals(this.validFrom())) {
            return false;
        }
        if (other.validUntil() == null ^ this.validUntil() == null) {
            return false;
        }
        if (other.validUntil() != null && !other.validUntil().equals(this.validUntil())) {
            return false;
        }
        if (other.replaceUnhealthyInstances() == null ^ this.replaceUnhealthyInstances() == null) {
            return false;
        }
        return other.replaceUnhealthyInstances() == null || other.replaceUnhealthyInstances().equals(this.replaceUnhealthyInstances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.allocationStrategyString() != null) {
            sb.append("AllocationStrategy: ").append(this.allocationStrategyString()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.excessCapacityTerminationPolicyString() != null) {
            sb.append("ExcessCapacityTerminationPolicy: ").append(this.excessCapacityTerminationPolicyString()).append(",");
        }
        if (this.fulfilledCapacity() != null) {
            sb.append("FulfilledCapacity: ").append(this.fulfilledCapacity()).append(",");
        }
        if (this.iamFleetRole() != null) {
            sb.append("IamFleetRole: ").append(this.iamFleetRole()).append(",");
        }
        if (this.launchSpecifications() != null) {
            sb.append("LaunchSpecifications: ").append(this.launchSpecifications()).append(",");
        }
        if (this.spotPrice() != null) {
            sb.append("SpotPrice: ").append(this.spotPrice()).append(",");
        }
        if (this.targetCapacity() != null) {
            sb.append("TargetCapacity: ").append(this.targetCapacity()).append(",");
        }
        if (this.terminateInstancesWithExpiration() != null) {
            sb.append("TerminateInstancesWithExpiration: ").append(this.terminateInstancesWithExpiration()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.validFrom() != null) {
            sb.append("ValidFrom: ").append(this.validFrom()).append(",");
        }
        if (this.validUntil() != null) {
            sb.append("ValidUntil: ").append(this.validUntil()).append(",");
        }
        if (this.replaceUnhealthyInstances() != null) {
            sb.append("ReplaceUnhealthyInstances: ").append(this.replaceUnhealthyInstances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationStrategy": {
                return Optional.of(clazz.cast(this.allocationStrategyString()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "ExcessCapacityTerminationPolicy": {
                return Optional.of(clazz.cast(this.excessCapacityTerminationPolicyString()));
            }
            case "FulfilledCapacity": {
                return Optional.of(clazz.cast(this.fulfilledCapacity()));
            }
            case "IamFleetRole": {
                return Optional.of(clazz.cast(this.iamFleetRole()));
            }
            case "LaunchSpecifications": {
                return Optional.of(clazz.cast(this.launchSpecifications()));
            }
            case "SpotPrice": {
                return Optional.of(clazz.cast(this.spotPrice()));
            }
            case "TargetCapacity": {
                return Optional.of(clazz.cast(this.targetCapacity()));
            }
            case "TerminateInstancesWithExpiration": {
                return Optional.of(clazz.cast(this.terminateInstancesWithExpiration()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "ValidFrom": {
                return Optional.of(clazz.cast(this.validFrom()));
            }
            case "ValidUntil": {
                return Optional.of(clazz.cast(this.validUntil()));
            }
            case "ReplaceUnhealthyInstances": {
                return Optional.of(clazz.cast(this.replaceUnhealthyInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String allocationStrategy;
        private String clientToken;
        private String excessCapacityTerminationPolicy;
        private Double fulfilledCapacity;
        private String iamFleetRole;
        private List<SpotFleetLaunchSpecification> launchSpecifications;
        private String spotPrice;
        private Integer targetCapacity;
        private Boolean terminateInstancesWithExpiration;
        private String type;
        private Instant validFrom;
        private Instant validUntil;
        private Boolean replaceUnhealthyInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotFleetRequestConfigData model) {
            this.allocationStrategy(model.allocationStrategy);
            this.clientToken(model.clientToken);
            this.excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            this.fulfilledCapacity(model.fulfilledCapacity);
            this.iamFleetRole(model.iamFleetRole);
            this.launchSpecifications(model.launchSpecifications);
            this.spotPrice(model.spotPrice);
            this.targetCapacity(model.targetCapacity);
            this.terminateInstancesWithExpiration(model.terminateInstancesWithExpiration);
            this.type(model.type);
            this.validFrom(model.validFrom);
            this.validUntil(model.validUntil);
            this.replaceUnhealthyInstances(model.replaceUnhealthyInstances);
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getExcessCapacityTerminationPolicy() {
            return this.excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final Double getFulfilledCapacity() {
            return this.fulfilledCapacity;
        }

        @Override
        public final Builder fulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
            return this;
        }

        public final void setFulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
        }

        public final String getIamFleetRole() {
            return this.iamFleetRole;
        }

        @Override
        public final Builder iamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
            return this;
        }

        public final void setIamFleetRole(String iamFleetRole) {
            this.iamFleetRole = iamFleetRole;
        }

        public final Collection<SpotFleetLaunchSpecification.Builder> getLaunchSpecifications() {
            return this.launchSpecifications != null ? (Collection)this.launchSpecifications.stream().map(SpotFleetLaunchSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copy(launchSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchSpecifications(SpotFleetLaunchSpecification ... launchSpecifications) {
            this.launchSpecifications(Arrays.asList(launchSpecifications));
            return this;
        }

        public final void setLaunchSpecifications(Collection<SpotFleetLaunchSpecification.BuilderImpl> launchSpecifications) {
            this.launchSpecifications = LaunchSpecsListCopier.copyFromBuilder(launchSpecifications);
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final Integer getTargetCapacity() {
            return this.targetCapacity;
        }

        @Override
        public final Builder targetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
            return this;
        }

        public final void setTargetCapacity(Integer targetCapacity) {
            this.targetCapacity = targetCapacity;
        }

        public final Boolean getTerminateInstancesWithExpiration() {
            return this.terminateInstancesWithExpiration;
        }

        @Override
        public final Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        public final void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final Boolean getReplaceUnhealthyInstances() {
            return this.replaceUnhealthyInstances;
        }

        @Override
        public final Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        public final void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
        }

        public SpotFleetRequestConfigData build() {
            return new SpotFleetRequestConfigData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotFleetRequestConfigData> {
        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(AllocationStrategy var1);

        public Builder clientToken(String var1);

        public Builder excessCapacityTerminationPolicy(String var1);

        public Builder excessCapacityTerminationPolicy(ExcessCapacityTerminationPolicy var1);

        public Builder fulfilledCapacity(Double var1);

        public Builder iamFleetRole(String var1);

        public Builder launchSpecifications(Collection<SpotFleetLaunchSpecification> var1);

        public Builder launchSpecifications(SpotFleetLaunchSpecification ... var1);

        public Builder spotPrice(String var1);

        public Builder targetCapacity(Integer var1);

        public Builder terminateInstancesWithExpiration(Boolean var1);

        public Builder type(String var1);

        public Builder type(FleetType var1);

        public Builder validFrom(Instant var1);

        public Builder validUntil(Instant var1);

        public Builder replaceUnhealthyInstances(Boolean var1);
    }
}

