/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SpotPrice
implements ToCopyableBuilder<Builder, SpotPrice> {
    private final String availabilityZone;
    private final String instanceType;
    private final String productDescription;
    private final String spotPrice;
    private final Instant timestamp;

    private SpotPrice(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.spotPrice = builder.spotPrice;
        this.timestamp = builder.timestamp;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeString() {
        return this.instanceType;
    }

    public RIProductDescription productDescription() {
        return RIProductDescription.fromValue(this.productDescription);
    }

    public String productDescriptionString() {
        return this.productDescription;
    }

    public String spotPrice() {
        return this.spotPrice;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.instanceTypeString() == null ? 0 : this.instanceTypeString().hashCode());
        hashCode = 31 * hashCode + (this.productDescriptionString() == null ? 0 : this.productDescriptionString().hashCode());
        hashCode = 31 * hashCode + (this.spotPrice() == null ? 0 : this.spotPrice().hashCode());
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotPrice)) {
            return false;
        }
        SpotPrice other = (SpotPrice)obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.instanceTypeString() == null ^ this.instanceTypeString() == null) {
            return false;
        }
        if (other.instanceTypeString() != null && !other.instanceTypeString().equals(this.instanceTypeString())) {
            return false;
        }
        if (other.productDescriptionString() == null ^ this.productDescriptionString() == null) {
            return false;
        }
        if (other.productDescriptionString() != null && !other.productDescriptionString().equals(this.productDescriptionString())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        return other.timestamp() == null || other.timestamp().equals(this.timestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.instanceTypeString() != null) {
            sb.append("InstanceType: ").append(this.instanceTypeString()).append(",");
        }
        if (this.productDescriptionString() != null) {
            sb.append("ProductDescription: ").append(this.productDescriptionString()).append(",");
        }
        if (this.spotPrice() != null) {
            sb.append("SpotPrice: ").append(this.spotPrice()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceTypeString()));
            }
            case "ProductDescription": {
                return Optional.of(clazz.cast(this.productDescriptionString()));
            }
            case "SpotPrice": {
                return Optional.of(clazz.cast(this.spotPrice()));
            }
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String instanceType;
        private String productDescription;
        private String spotPrice;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotPrice model) {
            this.availabilityZone(model.availabilityZone);
            this.instanceType(model.instanceType);
            this.productDescription(model.productDescription);
            this.spotPrice(model.spotPrice);
            this.timestamp(model.timestamp);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public SpotPrice build() {
            return new SpotPrice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotPrice> {
        public Builder availabilityZone(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder spotPrice(String var1);

        public Builder timestamp(Instant var1);
    }
}

