/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReason;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionVpcInfo;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcPeeringConnection
implements ToCopyableBuilder<Builder, VpcPeeringConnection> {
    private final VpcPeeringConnectionVpcInfo accepterVpcInfo;
    private final Instant expirationTime;
    private final VpcPeeringConnectionVpcInfo requesterVpcInfo;
    private final VpcPeeringConnectionStateReason status;
    private final List<Tag> tags;
    private final String vpcPeeringConnectionId;

    private VpcPeeringConnection(BuilderImpl builder) {
        this.accepterVpcInfo = builder.accepterVpcInfo;
        this.expirationTime = builder.expirationTime;
        this.requesterVpcInfo = builder.requesterVpcInfo;
        this.status = builder.status;
        this.tags = builder.tags;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public VpcPeeringConnectionVpcInfo accepterVpcInfo() {
        return this.accepterVpcInfo;
    }

    public Instant expirationTime() {
        return this.expirationTime;
    }

    public VpcPeeringConnectionVpcInfo requesterVpcInfo() {
        return this.requesterVpcInfo;
    }

    public VpcPeeringConnectionStateReason status() {
        return this.status;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accepterVpcInfo() == null ? 0 : this.accepterVpcInfo().hashCode());
        hashCode = 31 * hashCode + (this.expirationTime() == null ? 0 : this.expirationTime().hashCode());
        hashCode = 31 * hashCode + (this.requesterVpcInfo() == null ? 0 : this.requesterVpcInfo().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.vpcPeeringConnectionId() == null ? 0 : this.vpcPeeringConnectionId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnection)) {
            return false;
        }
        VpcPeeringConnection other = (VpcPeeringConnection)obj;
        if (other.accepterVpcInfo() == null ^ this.accepterVpcInfo() == null) {
            return false;
        }
        if (other.accepterVpcInfo() != null && !other.accepterVpcInfo().equals(this.accepterVpcInfo())) {
            return false;
        }
        if (other.expirationTime() == null ^ this.expirationTime() == null) {
            return false;
        }
        if (other.expirationTime() != null && !other.expirationTime().equals(this.expirationTime())) {
            return false;
        }
        if (other.requesterVpcInfo() == null ^ this.requesterVpcInfo() == null) {
            return false;
        }
        if (other.requesterVpcInfo() != null && !other.requesterVpcInfo().equals(this.requesterVpcInfo())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vpcPeeringConnectionId() == null ^ this.vpcPeeringConnectionId() == null) {
            return false;
        }
        return other.vpcPeeringConnectionId() == null || other.vpcPeeringConnectionId().equals(this.vpcPeeringConnectionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accepterVpcInfo() != null) {
            sb.append("AccepterVpcInfo: ").append(this.accepterVpcInfo()).append(",");
        }
        if (this.expirationTime() != null) {
            sb.append("ExpirationTime: ").append(this.expirationTime()).append(",");
        }
        if (this.requesterVpcInfo() != null) {
            sb.append("RequesterVpcInfo: ").append(this.requesterVpcInfo()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.vpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: ").append(this.vpcPeeringConnectionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccepterVpcInfo": {
                return Optional.of(clazz.cast(this.accepterVpcInfo()));
            }
            case "ExpirationTime": {
                return Optional.of(clazz.cast(this.expirationTime()));
            }
            case "RequesterVpcInfo": {
                return Optional.of(clazz.cast(this.requesterVpcInfo()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.of(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private VpcPeeringConnectionVpcInfo accepterVpcInfo;
        private Instant expirationTime;
        private VpcPeeringConnectionVpcInfo requesterVpcInfo;
        private VpcPeeringConnectionStateReason status;
        private List<Tag> tags;
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnection model) {
            this.accepterVpcInfo(model.accepterVpcInfo);
            this.expirationTime(model.expirationTime);
            this.requesterVpcInfo(model.requesterVpcInfo);
            this.status(model.status);
            this.tags(model.tags);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final VpcPeeringConnectionVpcInfo.Builder getAccepterVpcInfo() {
            return this.accepterVpcInfo != null ? this.accepterVpcInfo.toBuilder() : null;
        }

        @Override
        public final Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo;
            return this;
        }

        public final void setAccepterVpcInfo(VpcPeeringConnectionVpcInfo.BuilderImpl accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo != null ? accepterVpcInfo.build() : null;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        public final VpcPeeringConnectionVpcInfo.Builder getRequesterVpcInfo() {
            return this.requesterVpcInfo != null ? this.requesterVpcInfo.toBuilder() : null;
        }

        @Override
        public final Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo;
            return this;
        }

        public final void setRequesterVpcInfo(VpcPeeringConnectionVpcInfo.BuilderImpl requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo != null ? requesterVpcInfo.build() : null;
        }

        public final VpcPeeringConnectionStateReason.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(VpcPeeringConnectionStateReason status) {
            this.status = status;
            return this;
        }

        public final void setStatus(VpcPeeringConnectionStateReason.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        public VpcPeeringConnection build() {
            return new VpcPeeringConnection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcPeeringConnection> {
        public Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo var1);

        public Builder expirationTime(Instant var1);

        public Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo var1);

        public Builder status(VpcPeeringConnectionStateReason var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder vpcPeeringConnectionId(String var1);
    }
}

