/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.AllocateAddressRequest;

public class AllocateAddressRequestMarshaller
implements Marshaller<Request<AllocateAddressRequest>, AllocateAddressRequest> {
    public Request<AllocateAddressRequest> marshall(AllocateAddressRequest allocateAddressRequest) {
        if (allocateAddressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)allocateAddressRequest, "EC2Client");
        request.addParameter("Action", "AllocateAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (allocateAddressRequest.domainString() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)allocateAddressRequest.domainString()));
        }
        return request;
    }
}

