/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.AvailableCapacity;
import software.amazon.awssdk.services.ec2.model.InstanceCapacity;
import software.amazon.awssdk.services.ec2.transform.InstanceCapacityUnmarshaller;

public class AvailableCapacityUnmarshaller
implements Unmarshaller<AvailableCapacity, StaxUnmarshallerContext> {
    private static final AvailableCapacityUnmarshaller INSTANCE = new AvailableCapacityUnmarshaller();

    public AvailableCapacity unmarshall(StaxUnmarshallerContext context) throws Exception {
        AvailableCapacity.Builder availableCapacity;
        block6: {
            availableCapacity = AvailableCapacity.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<InstanceCapacity> availableInstanceCapacity = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    availableCapacity.availableInstanceCapacity(availableInstanceCapacity);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("availableInstanceCapacity", targetDepth)) {
                        availableInstanceCapacity = new ArrayList<InstanceCapacity>();
                        continue;
                    }
                    if (context.testExpression("availableInstanceCapacity/item", targetDepth)) {
                        availableInstanceCapacity.add(InstanceCapacityUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("availableVCpus", targetDepth)) continue;
                    availableCapacity.availableVCpus(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            availableCapacity.availableInstanceCapacity(availableInstanceCapacity);
        }
        return (AvailableCapacity)availableCapacity.build();
    }

    public static AvailableCapacityUnmarshaller getInstance() {
        return INSTANCE;
    }
}

