/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest;

public class CreateFlowLogsRequestMarshaller
implements Marshaller<Request<CreateFlowLogsRequest>, CreateFlowLogsRequest> {
    public Request<CreateFlowLogsRequest> marshall(CreateFlowLogsRequest createFlowLogsRequest) {
        List<String> createFlowLogsRequestResourceIdsList;
        if (createFlowLogsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createFlowLogsRequest, "EC2Client");
        request.addParameter("Action", "CreateFlowLogs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createFlowLogsRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createFlowLogsRequest.clientToken()));
        }
        if (createFlowLogsRequest.deliverLogsPermissionArn() != null) {
            request.addParameter("DeliverLogsPermissionArn", StringUtils.fromString((String)createFlowLogsRequest.deliverLogsPermissionArn()));
        }
        if (createFlowLogsRequest.logGroupName() != null) {
            request.addParameter("LogGroupName", StringUtils.fromString((String)createFlowLogsRequest.logGroupName()));
        }
        if ((createFlowLogsRequestResourceIdsList = createFlowLogsRequest.resourceIds()) != null) {
            int resourceIdsListIndex = 1;
            for (String createFlowLogsRequestResourceIdsListValue : createFlowLogsRequestResourceIdsList) {
                if (createFlowLogsRequestResourceIdsListValue != null) {
                    request.addParameter("ResourceId." + resourceIdsListIndex, StringUtils.fromString((String)createFlowLogsRequestResourceIdsListValue));
                }
                ++resourceIdsListIndex;
            }
        }
        if (createFlowLogsRequest.resourceTypeString() != null) {
            request.addParameter("ResourceType", StringUtils.fromString((String)createFlowLogsRequest.resourceTypeString()));
        }
        if (createFlowLogsRequest.trafficTypeString() != null) {
            request.addParameter("TrafficType", StringUtils.fromString((String)createFlowLogsRequest.trafficTypeString()));
        }
        return request;
    }
}

