/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateNatGatewayRequest;

public class CreateNatGatewayRequestMarshaller
implements Marshaller<Request<CreateNatGatewayRequest>, CreateNatGatewayRequest> {
    public Request<CreateNatGatewayRequest> marshall(CreateNatGatewayRequest createNatGatewayRequest) {
        if (createNatGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNatGatewayRequest, "EC2Client");
        request.addParameter("Action", "CreateNatGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNatGatewayRequest.allocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString((String)createNatGatewayRequest.allocationId()));
        }
        if (createNatGatewayRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createNatGatewayRequest.clientToken()));
        }
        if (createNatGatewayRequest.subnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)createNatGatewayRequest.subnetId()));
        }
        return request;
    }
}

