/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.VpnConnectionOptionsSpecification;

public class CreateVpnConnectionRequestMarshaller
implements Marshaller<Request<CreateVpnConnectionRequest>, CreateVpnConnectionRequest> {
    public Request<CreateVpnConnectionRequest> marshall(CreateVpnConnectionRequest createVpnConnectionRequest) {
        VpnConnectionOptionsSpecification options;
        if (createVpnConnectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVpnConnectionRequest, "EC2Client");
        request.addParameter("Action", "CreateVpnConnection");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpnConnectionRequest.customerGatewayId() != null) {
            request.addParameter("CustomerGatewayId", StringUtils.fromString((String)createVpnConnectionRequest.customerGatewayId()));
        }
        if (createVpnConnectionRequest.type() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createVpnConnectionRequest.type()));
        }
        if (createVpnConnectionRequest.vpnGatewayId() != null) {
            request.addParameter("VpnGatewayId", StringUtils.fromString((String)createVpnConnectionRequest.vpnGatewayId()));
        }
        if ((options = createVpnConnectionRequest.options()) != null && options.staticRoutesOnly() != null) {
            request.addParameter("Options.StaticRoutesOnly", StringUtils.fromBoolean((Boolean)options.staticRoutesOnly()));
        }
        return request;
    }
}

