/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DeleteDhcpOptionsRequest;

public class DeleteDhcpOptionsRequestMarshaller
implements Marshaller<Request<DeleteDhcpOptionsRequest>, DeleteDhcpOptionsRequest> {
    public Request<DeleteDhcpOptionsRequest> marshall(DeleteDhcpOptionsRequest deleteDhcpOptionsRequest) {
        if (deleteDhcpOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteDhcpOptionsRequest, "EC2Client");
        request.addParameter("Action", "DeleteDhcpOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteDhcpOptionsRequest.dhcpOptionsId() != null) {
            request.addParameter("DhcpOptionsId", StringUtils.fromString((String)deleteDhcpOptionsRequest.dhcpOptionsId()));
        }
        return request;
    }
}

