/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVolumesRequestMarshaller
implements Marshaller<Request<DescribeVolumesRequest>, DescribeVolumesRequest> {
    public Request<DescribeVolumesRequest> marshall(DescribeVolumesRequest describeVolumesRequest) {
        List<String> describeVolumesRequestVolumeIdsList;
        if (describeVolumesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVolumesRequest, "EC2Client");
        request.addParameter("Action", "DescribeVolumes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeVolumesRequestFiltersList = describeVolumesRequest.filters();
        if (describeVolumesRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeVolumesRequestFiltersListValue : describeVolumesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVolumesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVolumesRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeVolumesRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeVolumesRequestVolumeIdsList = describeVolumesRequest.volumeIds()) != null) {
            int volumeIdsListIndex = 1;
            for (String describeVolumesRequestVolumeIdsListValue : describeVolumesRequestVolumeIdsList) {
                if (describeVolumesRequestVolumeIdsListValue != null) {
                    request.addParameter("VolumeId." + volumeIdsListIndex, StringUtils.fromString((String)describeVolumesRequestVolumeIdsListValue));
                }
                ++volumeIdsListIndex;
            }
        }
        if (describeVolumesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVolumesRequest.maxResults()));
        }
        if (describeVolumesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVolumesRequest.nextToken()));
        }
        return request;
    }
}

