/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest;

public class DetachClassicLinkVpcRequestMarshaller
implements Marshaller<Request<DetachClassicLinkVpcRequest>, DetachClassicLinkVpcRequest> {
    public Request<DetachClassicLinkVpcRequest> marshall(DetachClassicLinkVpcRequest detachClassicLinkVpcRequest) {
        if (detachClassicLinkVpcRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachClassicLinkVpcRequest, "EC2Client");
        request.addParameter("Action", "DetachClassicLinkVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachClassicLinkVpcRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)detachClassicLinkVpcRequest.instanceId()));
        }
        if (detachClassicLinkVpcRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)detachClassicLinkVpcRequest.vpcId()));
        }
        return request;
    }
}

