/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpRange;
import software.amazon.awssdk.services.ec2.model.Ipv6Range;
import software.amazon.awssdk.services.ec2.model.PrefixListId;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;

public class RevokeSecurityGroupEgressRequestMarshaller
implements Marshaller<Request<RevokeSecurityGroupEgressRequest>, RevokeSecurityGroupEgressRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<RevokeSecurityGroupEgressRequest> marshall(RevokeSecurityGroupEgressRequest revokeSecurityGroupEgressRequest) {
        List<IpPermission> revokeSecurityGroupEgressRequestIpPermissionsList;
        if (revokeSecurityGroupEgressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)revokeSecurityGroupEgressRequest, "EC2Client");
        request.addParameter("Action", "RevokeSecurityGroupEgress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeSecurityGroupEgressRequest.groupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.groupId()));
        }
        if ((revokeSecurityGroupEgressRequestIpPermissionsList = revokeSecurityGroupEgressRequest.ipPermissions()) != null) {
            int ipPermissionsListIndex = 1;
            for (IpPermission revokeSecurityGroupEgressRequestIpPermissionsListValue : revokeSecurityGroupEgressRequestIpPermissionsList) {
                List<IpRange> list;
                List<UserIdGroupPair> ipPermissionUserIdGroupPairsList;
                List<PrefixListId> ipPermissionPrefixListIdsList;
                List<Ipv6Range> ipPermissionIpv6RangesList;
                if (revokeSecurityGroupEgressRequestIpPermissionsListValue.fromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequestIpPermissionsListValue.fromPort()));
                }
                if (revokeSecurityGroupEgressRequestIpPermissionsListValue.ipProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString((String)revokeSecurityGroupEgressRequestIpPermissionsListValue.ipProtocol()));
                }
                if ((ipPermissionIpv6RangesList = revokeSecurityGroupEgressRequestIpPermissionsListValue.ipv6Ranges()) != null) {
                    int ipv6RangesListIndex = 1;
                    for (Ipv6Range ipv6Range : ipPermissionIpv6RangesList) {
                        if (ipv6Range.cidrIpv6() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex + ".CidrIpv6", StringUtils.fromString((String)ipv6Range.cidrIpv6()));
                        }
                        ++ipv6RangesListIndex;
                    }
                }
                if ((ipPermissionPrefixListIdsList = revokeSecurityGroupEgressRequestIpPermissionsListValue.prefixListIds()) != null) {
                    int prefixListIdsListIndex = 1;
                    for (Object ipPermissionPrefixListIdsListValue : ipPermissionPrefixListIdsList) {
                        if (((PrefixListId)ipPermissionPrefixListIdsListValue).prefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString((String)((PrefixListId)ipPermissionPrefixListIdsListValue).prefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                if (revokeSecurityGroupEgressRequestIpPermissionsListValue.toPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequestIpPermissionsListValue.toPort()));
                }
                if ((ipPermissionUserIdGroupPairsList = revokeSecurityGroupEgressRequestIpPermissionsListValue.userIdGroupPairs()) != null) {
                    Object ipPermissionPrefixListIdsListValue;
                    boolean bl = true;
                    ipPermissionPrefixListIdsListValue = ipPermissionUserIdGroupPairsList.iterator();
                    while (ipPermissionPrefixListIdsListValue.hasNext()) {
                        void var10_18;
                        UserIdGroupPair ipPermissionUserIdGroupPairsListValue = (UserIdGroupPair)ipPermissionPrefixListIdsListValue.next();
                        if (ipPermissionUserIdGroupPairsListValue.groupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".GroupId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.groupId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.groupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".GroupName", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.groupName()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.peeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".PeeringStatus", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.peeringStatus()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.userId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".UserId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.userId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".VpcId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + (int)var10_18 + ".VpcPeeringConnectionId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId()));
                        }
                        ++var10_18;
                    }
                }
                if ((list = revokeSecurityGroupEgressRequestIpPermissionsListValue.ipv4Ranges()) != null) {
                    int ipv4RangesListIndex = 1;
                    for (IpRange ipPermissionIpv4RangesListValue : list) {
                        if (ipPermissionIpv4RangesListValue.cidrIp() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex + ".CidrIp", StringUtils.fromString((String)ipPermissionIpv4RangesListValue.cidrIp()));
                        }
                        ++ipv4RangesListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        if (revokeSecurityGroupEgressRequest.cidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.cidrIp()));
        }
        if (revokeSecurityGroupEgressRequest.fromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequest.fromPort()));
        }
        if (revokeSecurityGroupEgressRequest.ipProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.ipProtocol()));
        }
        if (revokeSecurityGroupEgressRequest.toPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequest.toPort()));
        }
        if (revokeSecurityGroupEgressRequest.sourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.sourceSecurityGroupName()));
        }
        if (revokeSecurityGroupEgressRequest.sourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.sourceSecurityGroupOwnerId()));
        }
        return request;
    }
}

