/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagSpecification;

public class RunInstancesRequestMarshaller
implements Marshaller<Request<RunInstancesRequest>, RunInstancesRequest> {
    /*
     * Could not resolve type clashes
     */
    public Request<RunInstancesRequest> marshall(RunInstancesRequest runInstancesRequest) {
        List<TagSpecification> runInstancesRequestTagSpecificationsList;
        List<InstanceNetworkInterfaceSpecification> runInstancesRequestNetworkInterfacesList;
        IamInstanceProfileSpecification iamInstanceProfile;
        List<String> runInstancesRequestSecurityGroupsList;
        List<String> runInstancesRequestSecurityGroupIdsList;
        Placement placement;
        List<InstanceIpv6Address> runInstancesRequestIpv6AddressesList;
        if (runInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runInstancesRequest, "EC2Client");
        request.addParameter("Action", "RunInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<BlockDeviceMapping> runInstancesRequestBlockDeviceMappingsList = runInstancesRequest.blockDeviceMappings();
        if (runInstancesRequestBlockDeviceMappingsList != null) {
            int blockDeviceMappingsListIndex = 1;
            for (Object runInstancesRequestBlockDeviceMappingsListValue : runInstancesRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).deviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).deviceName()));
                }
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).virtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).virtualName()));
                }
                if ((ebs = ((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).ebs()) != null) {
                    if (ebs.encrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.encrypted()));
                    }
                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.deleteOnTermination()));
                    }
                    if (ebs.iops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.iops()));
                    }
                    if (ebs.snapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.snapshotId()));
                    }
                    if (ebs.volumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.volumeSize()));
                    }
                    if (ebs.volumeTypeString() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.volumeTypeString()));
                    }
                }
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).noDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).noDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (runInstancesRequest.imageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)runInstancesRequest.imageId()));
        }
        if (runInstancesRequest.instanceTypeString() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)runInstancesRequest.instanceTypeString()));
        }
        if (runInstancesRequest.ipv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger((Integer)runInstancesRequest.ipv6AddressCount()));
        }
        if ((runInstancesRequestIpv6AddressesList = runInstancesRequest.ipv6Addresses()) != null) {
            int ipv6AddressesListIndex = 1;
            for (InstanceIpv6Address runInstancesRequestIpv6AddressesListValue : runInstancesRequestIpv6AddressesList) {
                if (runInstancesRequestIpv6AddressesListValue.ipv6Address() != null) {
                    request.addParameter("Ipv6Address." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)runInstancesRequestIpv6AddressesListValue.ipv6Address()));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (runInstancesRequest.kernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString((String)runInstancesRequest.kernelId()));
        }
        if (runInstancesRequest.keyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString((String)runInstancesRequest.keyName()));
        }
        if (runInstancesRequest.maxCount() != null) {
            request.addParameter("MaxCount", StringUtils.fromInteger((Integer)runInstancesRequest.maxCount()));
        }
        if (runInstancesRequest.minCount() != null) {
            request.addParameter("MinCount", StringUtils.fromInteger((Integer)runInstancesRequest.minCount()));
        }
        if (runInstancesRequest.monitoring() != null) {
            request.addParameter("Monitoring.Enabled", StringUtils.fromBoolean((Boolean)runInstancesRequest.monitoring()));
        }
        if ((placement = runInstancesRequest.placement()) != null) {
            if (placement.availabilityZone() != null) {
                request.addParameter("Placement.AvailabilityZone", StringUtils.fromString((String)placement.availabilityZone()));
            }
            if (placement.affinity() != null) {
                request.addParameter("Placement.Affinity", StringUtils.fromString((String)placement.affinity()));
            }
            if (placement.groupName() != null) {
                request.addParameter("Placement.GroupName", StringUtils.fromString((String)placement.groupName()));
            }
            if (placement.hostId() != null) {
                request.addParameter("Placement.HostId", StringUtils.fromString((String)placement.hostId()));
            }
            if (placement.tenancyString() != null) {
                request.addParameter("Placement.Tenancy", StringUtils.fromString((String)placement.tenancyString()));
            }
            if (placement.spreadDomain() != null) {
                request.addParameter("Placement.SpreadDomain", StringUtils.fromString((String)placement.spreadDomain()));
            }
        }
        if (runInstancesRequest.ramdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString((String)runInstancesRequest.ramdiskId()));
        }
        if ((runInstancesRequestSecurityGroupIdsList = runInstancesRequest.securityGroupIds()) != null) {
            int securityGroupIdsListIndex = 1;
            for (Object runInstancesRequestSecurityGroupIdsListValue : runInstancesRequestSecurityGroupIdsList) {
                if (runInstancesRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)runInstancesRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if ((runInstancesRequestSecurityGroupsList = runInstancesRequest.securityGroups()) != null) {
            int securityGroupsListIndex = 1;
            for (String runInstancesRequestSecurityGroupsListValue : runInstancesRequestSecurityGroupsList) {
                if (runInstancesRequestSecurityGroupsListValue != null) {
                    request.addParameter("SecurityGroup." + securityGroupsListIndex, StringUtils.fromString((String)runInstancesRequestSecurityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (runInstancesRequest.subnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)runInstancesRequest.subnetId()));
        }
        if (runInstancesRequest.userData() != null) {
            request.addParameter("UserData", StringUtils.fromString((String)runInstancesRequest.userData()));
        }
        if (runInstancesRequest.additionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)runInstancesRequest.additionalInfo()));
        }
        if (runInstancesRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)runInstancesRequest.clientToken()));
        }
        if (runInstancesRequest.disableApiTermination() != null) {
            request.addParameter("DisableApiTermination", StringUtils.fromBoolean((Boolean)runInstancesRequest.disableApiTermination()));
        }
        if (runInstancesRequest.ebsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean((Boolean)runInstancesRequest.ebsOptimized()));
        }
        if ((iamInstanceProfile = runInstancesRequest.iamInstanceProfile()) != null) {
            if (iamInstanceProfile.arn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.arn()));
            }
            if (iamInstanceProfile.name() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.name()));
            }
        }
        if (runInstancesRequest.instanceInitiatedShutdownBehaviorString() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior", StringUtils.fromString((String)runInstancesRequest.instanceInitiatedShutdownBehaviorString()));
        }
        if ((runInstancesRequestNetworkInterfacesList = runInstancesRequest.networkInterfaces()) != null) {
            int networkInterfacesListIndex = 1;
            for (InstanceNetworkInterfaceSpecification runInstancesRequestNetworkInterfacesListValue : runInstancesRequestNetworkInterfacesList) {
                List<PrivateIpAddressSpecification> instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                List<InstanceIpv6Address> instanceNetworkInterfaceSpecificationIpv6AddressesList;
                List<String> instanceNetworkInterfaceSpecificationGroupsList;
                if (runInstancesRequestNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)runInstancesRequestNetworkInterfacesListValue.associatePublicIpAddress()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.deleteOnTermination() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)runInstancesRequestNetworkInterfacesListValue.deleteOnTermination()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.description() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.description()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.deviceIndex() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)runInstancesRequestNetworkInterfacesListValue.deviceIndex()));
                }
                if ((instanceNetworkInterfaceSpecificationGroupsList = runInstancesRequestNetworkInterfacesListValue.groups()) != null) {
                    int groupsListIndex = 1;
                    for (Object instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                        if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                        }
                        ++groupsListIndex;
                    }
                }
                if (runInstancesRequestNetworkInterfacesListValue.ipv6AddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger((Integer)runInstancesRequestNetworkInterfacesListValue.ipv6AddressCount()));
                }
                if ((instanceNetworkInterfaceSpecificationIpv6AddressesList = runInstancesRequestNetworkInterfacesListValue.ipv6Addresses()) != null) {
                    Object instanceNetworkInterfaceSpecificationGroupsListValue;
                    int ipv6AddressesListIndex = 1;
                    instanceNetworkInterfaceSpecificationGroupsListValue = instanceNetworkInterfaceSpecificationIpv6AddressesList.iterator();
                    while (instanceNetworkInterfaceSpecificationGroupsListValue.hasNext()) {
                        InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue = (InstanceIpv6Address)instanceNetworkInterfaceSpecificationGroupsListValue.next();
                        if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address()));
                        }
                        ++ipv6AddressesListIndex;
                    }
                }
                if (runInstancesRequestNetworkInterfacesListValue.networkInterfaceId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.networkInterfaceId()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.privateIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.privateIpAddress()));
                }
                if ((instanceNetworkInterfaceSpecificationPrivateIpAddressesList = runInstancesRequestNetworkInterfacesListValue.privateIpAddresses()) != null) {
                    int privateIpAddressesListIndex = 1;
                    for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary()));
                        }
                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress()));
                        }
                        ++privateIpAddressesListIndex;
                    }
                }
                if (runInstancesRequestNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)runInstancesRequestNetworkInterfacesListValue.secondaryPrivateIpAddressCount()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.subnetId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.subnetId()));
                }
                ++networkInterfacesListIndex;
            }
        }
        if (runInstancesRequest.privateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)runInstancesRequest.privateIpAddress()));
        }
        if ((runInstancesRequestTagSpecificationsList = runInstancesRequest.tagSpecifications()) != null) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification runInstancesRequestTagSpecificationsListValue : runInstancesRequestTagSpecificationsList) {
                List<Tag> tagSpecificationTagsList;
                if (runInstancesRequestTagSpecificationsListValue.resourceTypeString() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)runInstancesRequestTagSpecificationsListValue.resourceTypeString()));
                }
                if ((tagSpecificationTagsList = runInstancesRequestTagSpecificationsListValue.tags()) != null) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.key() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.key()));
                        }
                        if (tagSpecificationTagsListValue.value() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.value()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

