/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a value of an account attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AccountAttributeValue implements ToCopyableBuilder<AccountAttributeValue.Builder, AccountAttributeValue> {
    private final String attributeValue;

    private AccountAttributeValue(BuilderImpl builder) {
        this.attributeValue = builder.attributeValue;
    }

    /**
     * <p>
     * The value of the attribute.
     * </p>
     * 
     * @return The value of the attribute.
     */
    public String attributeValue() {
        return attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAttributeValue)) {
            return false;
        }
        AccountAttributeValue other = (AccountAttributeValue) obj;
        return Objects.equals(attributeValue(), other.attributeValue());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (attributeValue() != null) {
            sb.append("AttributeValue: ").append(attributeValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeValue":
            return Optional.of(clazz.cast(attributeValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AccountAttributeValue> {
        /**
         * <p>
         * The value of the attribute.
         * </p>
         * 
         * @param attributeValue
         *        The value of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);
    }

    static final class BuilderImpl implements Builder {
        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAttributeValue model) {
            attributeValue(model.attributeValue);
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public AccountAttributeValue build() {
            return new AccountAttributeValue(this);
        }
    }
}
