/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a bundle task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BundleTask implements ToCopyableBuilder<BundleTask.Builder, BundleTask> {
    private final String bundleId;

    private final BundleTaskError bundleTaskError;

    private final String instanceId;

    private final String progress;

    private final Instant startTime;

    private final String state;

    private final Storage storage;

    private final Instant updateTime;

    private BundleTask(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.bundleTaskError = builder.bundleTaskError;
        this.instanceId = builder.instanceId;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.storage = builder.storage;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The ID of the bundle task.
     * </p>
     * 
     * @return The ID of the bundle task.
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * If the task fails, a description of the error.
     * </p>
     * 
     * @return If the task fails, a description of the error.
     */
    public BundleTaskError bundleTaskError() {
        return bundleTaskError;
    }

    /**
     * <p>
     * The ID of the instance associated with this bundle task.
     * </p>
     * 
     * @return The ID of the instance associated with this bundle task.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The level of task completion, as a percent (for example, 20%).
     * </p>
     * 
     * @return The level of task completion, as a percent (for example, 20%).
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * The time this task started.
     * </p>
     * 
     * @return The time this task started.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The state of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link BundleTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the task.
     * @see BundleTaskState
     */
    public BundleTaskState state() {
        return BundleTaskState.fromValue(state);
    }

    /**
     * <p>
     * The state of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link BundleTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the task.
     * @see BundleTaskState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The Amazon S3 storage locations.
     * </p>
     * 
     * @return The Amazon S3 storage locations.
     */
    public Storage storage() {
        return storage;
    }

    /**
     * <p>
     * The time of the most recent update for the task.
     * </p>
     * 
     * @return The time of the most recent update for the task.
     */
    public Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(bundleTaskError());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleTask)) {
            return false;
        }
        BundleTask other = (BundleTask) obj;
        return Objects.equals(bundleId(), other.bundleId()) && Objects.equals(bundleTaskError(), other.bundleTaskError())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(progress(), other.progress())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stateString(), other.stateString())
                && Objects.equals(storage(), other.storage()) && Objects.equals(updateTime(), other.updateTime());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (bundleId() != null) {
            sb.append("BundleId: ").append(bundleId()).append(",");
        }
        if (bundleTaskError() != null) {
            sb.append("BundleTaskError: ").append(bundleTaskError()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (progress() != null) {
            sb.append("Progress: ").append(progress()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (storage() != null) {
            sb.append("Storage: ").append(storage()).append(",");
        }
        if (updateTime() != null) {
            sb.append("UpdateTime: ").append(updateTime()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleId":
            return Optional.of(clazz.cast(bundleId()));
        case "BundleTaskError":
            return Optional.of(clazz.cast(bundleTaskError()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "Progress":
            return Optional.of(clazz.cast(progress()));
        case "StartTime":
            return Optional.of(clazz.cast(startTime()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "Storage":
            return Optional.of(clazz.cast(storage()));
        case "UpdateTime":
            return Optional.of(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, BundleTask> {
        /**
         * <p>
         * The ID of the bundle task.
         * </p>
         * 
         * @param bundleId
         *        The ID of the bundle task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * If the task fails, a description of the error.
         * </p>
         * 
         * @param bundleTaskError
         *        If the task fails, a description of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleTaskError(BundleTaskError bundleTaskError);

        /**
         * <p>
         * If the task fails, a description of the error.
         * </p>
         * This is a convenience that creates an instance of the {@link BundleTaskError.Builder} avoiding the need to
         * create one manually via {@link BundleTaskError#builder()}.
         *
         * When the {@link Consumer} completes, {@link BundleTaskError.Builder#build()} is called immediately and its
         * result is passed to {@link #bundleTaskError(BundleTaskError)}.
         * 
         * @param bundleTaskError
         *        a consumer that will call methods on {@link BundleTaskError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bundleTaskError(BundleTaskError)
         */
        default Builder bundleTaskError(Consumer<BundleTaskError.Builder> bundleTaskError) {
            return bundleTaskError(BundleTaskError.builder().apply(bundleTaskError).build());
        }

        /**
         * <p>
         * The ID of the instance associated with this bundle task.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance associated with this bundle task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The level of task completion, as a percent (for example, 20%).
         * </p>
         * 
         * @param progress
         *        The level of task completion, as a percent (for example, 20%).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The time this task started.
         * </p>
         * 
         * @param startTime
         *        The time this task started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The state of the task.
         * </p>
         * 
         * @param state
         *        The state of the task.
         * @see BundleTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BundleTaskState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the task.
         * </p>
         * 
         * @param state
         *        The state of the task.
         * @see BundleTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BundleTaskState
         */
        Builder state(BundleTaskState state);

        /**
         * <p>
         * The Amazon S3 storage locations.
         * </p>
         * 
         * @param storage
         *        The Amazon S3 storage locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(Storage storage);

        /**
         * <p>
         * The Amazon S3 storage locations.
         * </p>
         * This is a convenience that creates an instance of the {@link Storage.Builder} avoiding the need to create one
         * manually via {@link Storage#builder()}.
         *
         * When the {@link Consumer} completes, {@link Storage.Builder#build()} is called immediately and its result is
         * passed to {@link #storage(Storage)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link Storage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(Storage)
         */
        default Builder storage(Consumer<Storage.Builder> storage) {
            return storage(Storage.builder().apply(storage).build());
        }

        /**
         * <p>
         * The time of the most recent update for the task.
         * </p>
         * 
         * @param updateTime
         *        The time of the most recent update for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String bundleId;

        private BundleTaskError bundleTaskError;

        private String instanceId;

        private String progress;

        private Instant startTime;

        private String state;

        private Storage storage;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BundleTask model) {
            bundleId(model.bundleId);
            bundleTaskError(model.bundleTaskError);
            instanceId(model.instanceId);
            progress(model.progress);
            startTime(model.startTime);
            state(model.state);
            storage(model.storage);
            updateTime(model.updateTime);
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final BundleTaskError.Builder getBundleTaskError() {
            return bundleTaskError != null ? bundleTaskError.toBuilder() : null;
        }

        @Override
        public final Builder bundleTaskError(BundleTaskError bundleTaskError) {
            this.bundleTaskError = bundleTaskError;
            return this;
        }

        public final void setBundleTaskError(BundleTaskError.BuilderImpl bundleTaskError) {
            this.bundleTaskError = bundleTaskError != null ? bundleTaskError.build() : null;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BundleTaskState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Storage.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        @Override
        public final Builder storage(Storage storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(Storage.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public BundleTask build() {
            return new BundleTask(this);
        }
    }
}
