/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CancelSpotFleetRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelSpotFleetRequestsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CancelSpotFleetRequestsResponse.Builder, CancelSpotFleetRequestsResponse> {
    private final List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests;

    private final List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests;

    private CancelSpotFleetRequestsResponse(BuilderImpl builder) {
        this.successfulFleetRequests = builder.successfulFleetRequests;
        this.unsuccessfulFleetRequests = builder.unsuccessfulFleetRequests;
    }

    /**
     * <p>
     * Information about the Spot fleet requests that are successfully canceled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Spot fleet requests that are successfully canceled.
     */
    public List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests() {
        return successfulFleetRequests;
    }

    /**
     * <p>
     * Information about the Spot fleet requests that are not successfully canceled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Spot fleet requests that are not successfully canceled.
     */
    public List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests() {
        return unsuccessfulFleetRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(successfulFleetRequests());
        hashCode = 31 * hashCode + Objects.hashCode(unsuccessfulFleetRequests());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsResponse)) {
            return false;
        }
        CancelSpotFleetRequestsResponse other = (CancelSpotFleetRequestsResponse) obj;
        return Objects.equals(successfulFleetRequests(), other.successfulFleetRequests())
                && Objects.equals(unsuccessfulFleetRequests(), other.unsuccessfulFleetRequests());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (successfulFleetRequests() != null) {
            sb.append("SuccessfulFleetRequests: ").append(successfulFleetRequests()).append(",");
        }
        if (unsuccessfulFleetRequests() != null) {
            sb.append("UnsuccessfulFleetRequests: ").append(unsuccessfulFleetRequests()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfulFleetRequests":
            return Optional.of(clazz.cast(successfulFleetRequests()));
        case "UnsuccessfulFleetRequests":
            return Optional.of(clazz.cast(unsuccessfulFleetRequests()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CancelSpotFleetRequestsResponse> {
        /**
         * <p>
         * Information about the Spot fleet requests that are successfully canceled.
         * </p>
         * 
         * @param successfulFleetRequests
         *        Information about the Spot fleet requests that are successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests);

        /**
         * <p>
         * Information about the Spot fleet requests that are successfully canceled.
         * </p>
         * 
         * @param successfulFleetRequests
         *        Information about the Spot fleet requests that are successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem... successfulFleetRequests);

        /**
         * <p>
         * Information about the Spot fleet requests that are not successfully canceled.
         * </p>
         * 
         * @param unsuccessfulFleetRequests
         *        Information about the Spot fleet requests that are not successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests);

        /**
         * <p>
         * Information about the Spot fleet requests that are not successfully canceled.
         * </p>
         * 
         * @param unsuccessfulFleetRequests
         *        Information about the Spot fleet requests that are not successfully canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem... unsuccessfulFleetRequests);
    }

    static final class BuilderImpl implements Builder {
        private List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests;

        private List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsResponse model) {
            successfulFleetRequests(model.successfulFleetRequests);
            unsuccessfulFleetRequests(model.unsuccessfulFleetRequests);
        }

        public final Collection<CancelSpotFleetRequestsSuccessItem.Builder> getSuccessfulFleetRequests() {
            return successfulFleetRequests != null ? successfulFleetRequests.stream()
                    .map(CancelSpotFleetRequestsSuccessItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copy(successfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem... successfulFleetRequests) {
            successfulFleetRequests(Arrays.asList(successfulFleetRequests));
            return this;
        }

        public final void setSuccessfulFleetRequests(
                Collection<CancelSpotFleetRequestsSuccessItem.BuilderImpl> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copyFromBuilder(successfulFleetRequests);
        }

        public final Collection<CancelSpotFleetRequestsErrorItem.Builder> getUnsuccessfulFleetRequests() {
            return unsuccessfulFleetRequests != null ? unsuccessfulFleetRequests.stream()
                    .map(CancelSpotFleetRequestsErrorItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copy(unsuccessfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem... unsuccessfulFleetRequests) {
            unsuccessfulFleetRequests(Arrays.asList(unsuccessfulFleetRequests));
            return this;
        }

        public final void setUnsuccessfulFleetRequests(
                Collection<CancelSpotFleetRequestsErrorItem.BuilderImpl> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copyFromBuilder(unsuccessfulFleetRequests);
        }

        @Override
        public CancelSpotFleetRequestsResponse build() {
            return new CancelSpotFleetRequestsResponse(this);
        }
    }
}
